/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1.sink;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.events.v1.sink.SinkTest;

public class SinkTestCreator
extends Creator<SinkTest> {
    private String pathSid;

    public SinkTestCreator(String pathSid) {
        this.pathSid = pathSid;
    }

    @Override
    public SinkTest create(TwilioRestClient client) {
        String path = "/v1/Sinks/{Sid}/Test";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.EVENTS.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SinkTest creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return SinkTest.fromJson(response.getStream(), client.getObjectMapper());
    }
}

