/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1.schema;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.events.v1.schema.SchemaVersion;

public class SchemaVersionReader
extends Reader<SchemaVersion> {
    private String pathId;
    private Integer pageSize;

    public SchemaVersionReader(String pathId) {
        this.pathId = pathId;
    }

    public SchemaVersionReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<SchemaVersion> read(TwilioRestClient client) {
        return new ResourceSet<SchemaVersion>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SchemaVersion> firstPage(TwilioRestClient client) {
        String path = "/v1/Schemas/{Id}/Versions";
        path = path.replace("{Id}", this.pathId.toString());
        Request request = new Request(HttpMethod.GET, Domains.EVENTS.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<SchemaVersion> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SchemaVersion read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("schema_versions", response.getContent(), SchemaVersion.class, client.getObjectMapper());
    }

    @Override
    public Page<SchemaVersion> previousPage(Page<SchemaVersion> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.EVENTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SchemaVersion> nextPage(Page<SchemaVersion> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.EVENTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SchemaVersion> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

