/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.events.v1.Subscription;
import java.util.List;
import java.util.Map;

public class SubscriptionCreator
extends Creator<Subscription> {
    private String description;
    private String sinkSid;
    private List<Map<String, Object>> types;

    public SubscriptionCreator(String description, String sinkSid, List<Map<String, Object>> types) {
        this.description = description;
        this.sinkSid = sinkSid;
        this.types = types;
    }

    public SubscriptionCreator setDescription(String description) {
        this.description = description;
        return this;
    }

    public SubscriptionCreator setSinkSid(String sinkSid) {
        this.sinkSid = sinkSid;
        return this;
    }

    public SubscriptionCreator setTypes(List<Map<String, Object>> types) {
        this.types = types;
        return this;
    }

    public SubscriptionCreator setTypes(Map<String, Object> types) {
        return this.setTypes(Promoter.listOfOne(types));
    }

    @Override
    public Subscription create(TwilioRestClient client) {
        String path = "/v1/Subscriptions";
        path = path.replace("{Description}", this.description.toString());
        path = path.replace("{SinkSid}", this.sinkSid.toString());
        path = path.replace("{Types}", this.types.toString());
        Request request = new Request(HttpMethod.POST, Domains.EVENTS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Subscription creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Subscription.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.description != null) {
            request.addPostParam("Description", this.description);
        }
        if (this.sinkSid != null) {
            request.addPostParam("SinkSid", this.sinkSid);
        }
        if (this.types != null) {
            for (Map<String, Object> prop : this.types) {
                request.addPostParam("Types", Converter.mapToJson(prop));
            }
        }
    }
}

