/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.events.v1.Sink;
import java.util.Map;

public class SinkCreator
extends Creator<Sink> {
    private String description;
    private Map<String, Object> sinkConfiguration;
    private Sink.SinkType sinkType;

    public SinkCreator(String description, Map<String, Object> sinkConfiguration, Sink.SinkType sinkType) {
        this.description = description;
        this.sinkConfiguration = sinkConfiguration;
        this.sinkType = sinkType;
    }

    public SinkCreator setDescription(String description) {
        this.description = description;
        return this;
    }

    public SinkCreator setSinkConfiguration(Map<String, Object> sinkConfiguration) {
        this.sinkConfiguration = sinkConfiguration;
        return this;
    }

    public SinkCreator setSinkType(Sink.SinkType sinkType) {
        this.sinkType = sinkType;
        return this;
    }

    @Override
    public Sink create(TwilioRestClient client) {
        String path = "/v1/Sinks";
        path = path.replace("{Description}", this.description.toString());
        path = path.replace("{SinkConfiguration}", this.sinkConfiguration.toString());
        path = path.replace("{SinkType}", this.sinkType.toString());
        Request request = new Request(HttpMethod.POST, Domains.EVENTS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Sink creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Sink.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.description != null) {
            request.addPostParam("Description", this.description);
        }
        if (this.sinkConfiguration != null) {
            request.addPostParam("SinkConfiguration", Converter.mapToJson(this.sinkConfiguration));
        }
        if (this.sinkType != null) {
            request.addPostParam("SinkType", this.sinkType.toString());
        }
    }
}

