/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.service.configuration.WebhookFetcher;
import com.twilio.rest.conversations.v1.service.configuration.WebhookUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Webhook
extends Resource {
    private static final long serialVersionUID = 148454673918473L;
    private final String accountSid;
    private final String chatServiceSid;
    private final URI preWebhookUrl;
    private final URI postWebhookUrl;
    private final List<String> filters;
    private final Method method;
    private final URI url;

    public static WebhookFetcher fetcher(String pathChatServiceSid) {
        return new WebhookFetcher(pathChatServiceSid);
    }

    public static WebhookUpdater updater(String pathChatServiceSid) {
        return new WebhookUpdater(pathChatServiceSid);
    }

    public static Webhook fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Webhook fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Webhook(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="chat_service_sid") String chatServiceSid, @JsonProperty(value="pre_webhook_url") URI preWebhookUrl, @JsonProperty(value="post_webhook_url") URI postWebhookUrl, @JsonProperty(value="filters") List<String> filters, @JsonProperty(value="method") Method method, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.chatServiceSid = chatServiceSid;
        this.preWebhookUrl = preWebhookUrl;
        this.postWebhookUrl = postWebhookUrl;
        this.filters = filters;
        this.method = method;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    public final URI getPreWebhookUrl() {
        return this.preWebhookUrl;
    }

    public final URI getPostWebhookUrl() {
        return this.postWebhookUrl;
    }

    public final List<String> getFilters() {
        return this.filters;
    }

    public final Method getMethod() {
        return this.method;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook other = (Webhook)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.chatServiceSid, other.chatServiceSid) && Objects.equals(this.preWebhookUrl, other.preWebhookUrl) && Objects.equals(this.postWebhookUrl, other.postWebhookUrl) && Objects.equals(this.filters, other.filters) && Objects.equals((Object)this.method, (Object)other.method) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.chatServiceSid, this.preWebhookUrl, this.postWebhookUrl, this.filters, this.method, this.url});
    }

    public String toString() {
        return "Webhook(accountSid=" + this.getAccountSid() + ", chatServiceSid=" + this.getChatServiceSid() + ", preWebhookUrl=" + this.getPreWebhookUrl() + ", postWebhookUrl=" + this.getPostWebhookUrl() + ", filters=" + this.getFilters() + ", method=" + (Object)((Object)this.getMethod()) + ", url=" + this.getUrl() + ")";
    }

    public static enum Method {
        GET("GET"),
        POST("POST");

        private final String value;

        private Method(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Method forValue(String value) {
            return (Method)Promoter.enumFromString((String)value, (Enum[])Method.values());
        }
    }
}

