/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.configuration;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.configuration.Notification;

public class NotificationUpdater
extends Updater<Notification> {
    private String pathChatServiceSid;
    private Boolean logEnabled;
    private Boolean newMessageEnabled;
    private String newMessageTemplate;
    private String newMessageSound;
    private Boolean newMessageBadgeCountEnabled;
    private Boolean addedToConversationEnabled;
    private String addedToConversationTemplate;
    private String addedToConversationSound;
    private Boolean removedFromConversationEnabled;
    private String removedFromConversationTemplate;
    private String removedFromConversationSound;
    private Boolean newMessageWithMediaEnabled;
    private String newMessageWithMediaTemplate;

    public NotificationUpdater(String pathChatServiceSid) {
        this.pathChatServiceSid = pathChatServiceSid;
    }

    public NotificationUpdater setLogEnabled(Boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    public NotificationUpdater setNewMessageEnabled(Boolean newMessageEnabled) {
        this.newMessageEnabled = newMessageEnabled;
        return this;
    }

    public NotificationUpdater setNewMessageTemplate(String newMessageTemplate) {
        this.newMessageTemplate = newMessageTemplate;
        return this;
    }

    public NotificationUpdater setNewMessageSound(String newMessageSound) {
        this.newMessageSound = newMessageSound;
        return this;
    }

    public NotificationUpdater setNewMessageBadgeCountEnabled(Boolean newMessageBadgeCountEnabled) {
        this.newMessageBadgeCountEnabled = newMessageBadgeCountEnabled;
        return this;
    }

    public NotificationUpdater setAddedToConversationEnabled(Boolean addedToConversationEnabled) {
        this.addedToConversationEnabled = addedToConversationEnabled;
        return this;
    }

    public NotificationUpdater setAddedToConversationTemplate(String addedToConversationTemplate) {
        this.addedToConversationTemplate = addedToConversationTemplate;
        return this;
    }

    public NotificationUpdater setAddedToConversationSound(String addedToConversationSound) {
        this.addedToConversationSound = addedToConversationSound;
        return this;
    }

    public NotificationUpdater setRemovedFromConversationEnabled(Boolean removedFromConversationEnabled) {
        this.removedFromConversationEnabled = removedFromConversationEnabled;
        return this;
    }

    public NotificationUpdater setRemovedFromConversationTemplate(String removedFromConversationTemplate) {
        this.removedFromConversationTemplate = removedFromConversationTemplate;
        return this;
    }

    public NotificationUpdater setRemovedFromConversationSound(String removedFromConversationSound) {
        this.removedFromConversationSound = removedFromConversationSound;
        return this;
    }

    public NotificationUpdater setNewMessageWithMediaEnabled(Boolean newMessageWithMediaEnabled) {
        this.newMessageWithMediaEnabled = newMessageWithMediaEnabled;
        return this;
    }

    public NotificationUpdater setNewMessageWithMediaTemplate(String newMessageWithMediaTemplate) {
        this.newMessageWithMediaTemplate = newMessageWithMediaTemplate;
        return this;
    }

    @Override
    public Notification update(TwilioRestClient client) {
        String path = "/v1/Services/{ChatServiceSid}/Configuration/Notifications";
        path = path.replace("{ChatServiceSid}", this.pathChatServiceSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Notification update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Notification.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.logEnabled != null) {
            request.addPostParam("LogEnabled", this.logEnabled.toString());
        }
        if (this.newMessageEnabled != null) {
            request.addPostParam("NewMessage.Enabled", this.newMessageEnabled.toString());
        }
        if (this.newMessageTemplate != null) {
            request.addPostParam("NewMessage.Template", this.newMessageTemplate);
        }
        if (this.newMessageSound != null) {
            request.addPostParam("NewMessage.Sound", this.newMessageSound);
        }
        if (this.newMessageBadgeCountEnabled != null) {
            request.addPostParam("NewMessage.BadgeCountEnabled", this.newMessageBadgeCountEnabled.toString());
        }
        if (this.addedToConversationEnabled != null) {
            request.addPostParam("AddedToConversation.Enabled", this.addedToConversationEnabled.toString());
        }
        if (this.addedToConversationTemplate != null) {
            request.addPostParam("AddedToConversation.Template", this.addedToConversationTemplate);
        }
        if (this.addedToConversationSound != null) {
            request.addPostParam("AddedToConversation.Sound", this.addedToConversationSound);
        }
        if (this.removedFromConversationEnabled != null) {
            request.addPostParam("RemovedFromConversation.Enabled", this.removedFromConversationEnabled.toString());
        }
        if (this.removedFromConversationTemplate != null) {
            request.addPostParam("RemovedFromConversation.Template", this.removedFromConversationTemplate);
        }
        if (this.removedFromConversationSound != null) {
            request.addPostParam("RemovedFromConversation.Sound", this.removedFromConversationSound);
        }
        if (this.newMessageWithMediaEnabled != null) {
            request.addPostParam("NewMessage.WithMedia.Enabled", this.newMessageWithMediaEnabled.toString());
        }
        if (this.newMessageWithMediaTemplate != null) {
            request.addPostParam("NewMessage.WithMedia.Template", this.newMessageWithMediaTemplate);
        }
    }
}

