/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.service.UserCreator;
import com.twilio.rest.conversations.v1.service.UserDeleter;
import com.twilio.rest.conversations.v1.service.UserFetcher;
import com.twilio.rest.conversations.v1.service.UserReader;
import com.twilio.rest.conversations.v1.service.UserUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class User
extends Resource {
    private static final long serialVersionUID = 270629422616663L;
    private final String sid;
    private final String accountSid;
    private final String chatServiceSid;
    private final String roleSid;
    private final String identity;
    private final String friendlyName;
    private final String attributes;
    private final Boolean isOnline;
    private final Boolean isNotifiable;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static UserCreator creator(String pathChatServiceSid, String identity) {
        return new UserCreator(pathChatServiceSid, identity);
    }

    public static UserDeleter deleter(String pathChatServiceSid, String pathSid) {
        return new UserDeleter(pathChatServiceSid, pathSid);
    }

    public static UserFetcher fetcher(String pathChatServiceSid, String pathSid) {
        return new UserFetcher(pathChatServiceSid, pathSid);
    }

    public static UserReader reader(String pathChatServiceSid) {
        return new UserReader(pathChatServiceSid);
    }

    public static UserUpdater updater(String pathChatServiceSid, String pathSid) {
        return new UserUpdater(pathChatServiceSid, pathSid);
    }

    public static User fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, User.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static User fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, User.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private User(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="chat_service_sid") String chatServiceSid, @JsonProperty(value="role_sid") String roleSid, @JsonProperty(value="identity") String identity, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="is_online") Boolean isOnline, @JsonProperty(value="is_notifiable") Boolean isNotifiable, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.chatServiceSid = chatServiceSid;
        this.roleSid = roleSid;
        this.identity = identity;
        this.friendlyName = friendlyName;
        this.attributes = attributes;
        this.isOnline = isOnline;
        this.isNotifiable = isNotifiable;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    public final String getRoleSid() {
        return this.roleSid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final Boolean getIsOnline() {
        return this.isOnline;
    }

    public final Boolean getIsNotifiable() {
        return this.isNotifiable;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User other = (User)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.chatServiceSid, other.chatServiceSid) && Objects.equals(this.roleSid, other.roleSid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.isOnline, other.isOnline) && Objects.equals(this.isNotifiable, other.isNotifiable) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.chatServiceSid, this.roleSid, this.identity, this.friendlyName, this.attributes, this.isOnline, this.isNotifiable, this.dateCreated, this.dateUpdated, this.url, this.links);
    }

    public String toString() {
        return "User(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", chatServiceSid=" + this.getChatServiceSid() + ", roleSid=" + this.getRoleSid() + ", identity=" + this.getIdentity() + ", friendlyName=" + this.getFriendlyName() + ", attributes=" + this.getAttributes() + ", isOnline=" + this.getIsOnline() + ", isNotifiable=" + this.getIsNotifiable() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }

    public static enum WebhookEnabledType {
        TRUE("true"),
        FALSE("false");

        private final String value;

        private WebhookEnabledType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static WebhookEnabledType forValue(String value) {
            return (WebhookEnabledType)Promoter.enumFromString((String)value, (Enum[])WebhookEnabledType.values());
        }
    }
}

