/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.Conversation;

public class ConversationFetcher
extends Fetcher<Conversation> {
    private String pathChatServiceSid;
    private String pathSid;

    public ConversationFetcher(String pathChatServiceSid, String pathSid) {
        this.pathChatServiceSid = pathChatServiceSid;
        this.pathSid = pathSid;
    }

    @Override
    public Conversation fetch(TwilioRestClient client) {
        String path = "/v1/Services/{ChatServiceSid}/Conversations/{Sid}";
        path = path.replace("{ChatServiceSid}", this.pathChatServiceSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.CONVERSATIONS.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Conversation fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Conversation.fromJson(response.getStream(), client.getObjectMapper());
    }
}

