/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.service.ConfigurationFetcher;
import com.twilio.rest.conversations.v1.service.ConfigurationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Configuration
extends Resource {
    private static final long serialVersionUID = 35465460450497L;
    private final String chatServiceSid;
    private final String defaultConversationCreatorRoleSid;
    private final String defaultConversationRoleSid;
    private final String defaultChatServiceRoleSid;
    private final URI url;
    private final Map<String, String> links;
    private final Boolean reachabilityEnabled;

    public static ConfigurationFetcher fetcher(String pathChatServiceSid) {
        return new ConfigurationFetcher(pathChatServiceSid);
    }

    public static ConfigurationUpdater updater(String pathChatServiceSid) {
        return new ConfigurationUpdater(pathChatServiceSid);
    }

    public static Configuration fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Configuration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Configuration fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Configuration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Configuration(@JsonProperty(value="chat_service_sid") String chatServiceSid, @JsonProperty(value="default_conversation_creator_role_sid") String defaultConversationCreatorRoleSid, @JsonProperty(value="default_conversation_role_sid") String defaultConversationRoleSid, @JsonProperty(value="default_chat_service_role_sid") String defaultChatServiceRoleSid, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="reachability_enabled") Boolean reachabilityEnabled) {
        this.chatServiceSid = chatServiceSid;
        this.defaultConversationCreatorRoleSid = defaultConversationCreatorRoleSid;
        this.defaultConversationRoleSid = defaultConversationRoleSid;
        this.defaultChatServiceRoleSid = defaultChatServiceRoleSid;
        this.url = url;
        this.links = links;
        this.reachabilityEnabled = reachabilityEnabled;
    }

    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    public final String getDefaultConversationCreatorRoleSid() {
        return this.defaultConversationCreatorRoleSid;
    }

    public final String getDefaultConversationRoleSid() {
        return this.defaultConversationRoleSid;
    }

    public final String getDefaultChatServiceRoleSid() {
        return this.defaultChatServiceRoleSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final Boolean getReachabilityEnabled() {
        return this.reachabilityEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration other = (Configuration)o;
        return Objects.equals(this.chatServiceSid, other.chatServiceSid) && Objects.equals(this.defaultConversationCreatorRoleSid, other.defaultConversationCreatorRoleSid) && Objects.equals(this.defaultConversationRoleSid, other.defaultConversationRoleSid) && Objects.equals(this.defaultChatServiceRoleSid, other.defaultChatServiceRoleSid) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links) && Objects.equals(this.reachabilityEnabled, other.reachabilityEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.chatServiceSid, this.defaultConversationCreatorRoleSid, this.defaultConversationRoleSid, this.defaultChatServiceRoleSid, this.url, this.links, this.reachabilityEnabled);
    }

    public String toString() {
        return "Configuration(chatServiceSid=" + this.getChatServiceSid() + ", defaultConversationCreatorRoleSid=" + this.getDefaultConversationCreatorRoleSid() + ", defaultConversationRoleSid=" + this.getDefaultConversationRoleSid() + ", defaultChatServiceRoleSid=" + this.getDefaultChatServiceRoleSid() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ", reachabilityEnabled=" + this.getReachabilityEnabled() + ")";
    }
}

