/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.conversation;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.conversation.Webhook;

public class WebhookReader
extends Reader<Webhook> {
    private String pathConversationSid;
    private Integer pageSize;

    public WebhookReader(String pathConversationSid) {
        this.pathConversationSid = pathConversationSid;
    }

    public WebhookReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Webhook> read(TwilioRestClient client) {
        return new ResourceSet<Webhook>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Webhook> firstPage(TwilioRestClient client) {
        String path = "/v1/Conversations/{ConversationSid}/Webhooks";
        path = path.replace("{ConversationSid}", this.pathConversationSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.CONVERSATIONS.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Webhook> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Webhook read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("webhooks", response.getContent(), Webhook.class, client.getObjectMapper());
    }

    @Override
    public Page<Webhook> previousPage(Page<Webhook> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Webhook> nextPage(Page<Webhook> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Webhook> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

