/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.ConfigurationFetcher;
import com.twilio.rest.conversations.v1.ConfigurationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Configuration
extends Resource {
    private static final long serialVersionUID = 31286932068884L;
    private final String accountSid;
    private final String defaultChatServiceSid;
    private final String defaultMessagingServiceSid;
    private final String defaultInactiveTimer;
    private final String defaultClosedTimer;
    private final URI url;
    private final Map<String, String> links;

    public static ConfigurationFetcher fetcher() {
        return new ConfigurationFetcher();
    }

    public static ConfigurationUpdater updater() {
        return new ConfigurationUpdater();
    }

    public static Configuration fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Configuration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Configuration fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Configuration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Configuration(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="default_chat_service_sid") String defaultChatServiceSid, @JsonProperty(value="default_messaging_service_sid") String defaultMessagingServiceSid, @JsonProperty(value="default_inactive_timer") String defaultInactiveTimer, @JsonProperty(value="default_closed_timer") String defaultClosedTimer, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.defaultChatServiceSid = defaultChatServiceSid;
        this.defaultMessagingServiceSid = defaultMessagingServiceSid;
        this.defaultInactiveTimer = defaultInactiveTimer;
        this.defaultClosedTimer = defaultClosedTimer;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getDefaultChatServiceSid() {
        return this.defaultChatServiceSid;
    }

    public final String getDefaultMessagingServiceSid() {
        return this.defaultMessagingServiceSid;
    }

    public final String getDefaultInactiveTimer() {
        return this.defaultInactiveTimer;
    }

    public final String getDefaultClosedTimer() {
        return this.defaultClosedTimer;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration other = (Configuration)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.defaultChatServiceSid, other.defaultChatServiceSid) && Objects.equals(this.defaultMessagingServiceSid, other.defaultMessagingServiceSid) && Objects.equals(this.defaultInactiveTimer, other.defaultInactiveTimer) && Objects.equals(this.defaultClosedTimer, other.defaultClosedTimer) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.defaultChatServiceSid, this.defaultMessagingServiceSid, this.defaultInactiveTimer, this.defaultClosedTimer, this.url, this.links);
    }

    public String toString() {
        return "Configuration(accountSid=" + this.getAccountSid() + ", defaultChatServiceSid=" + this.getDefaultChatServiceSid() + ", defaultMessagingServiceSid=" + this.getDefaultMessagingServiceSid() + ", defaultInactiveTimer=" + this.getDefaultInactiveTimer() + ", defaultClosedTimer=" + this.getDefaultClosedTimer() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }
}

