/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.AddressConfiguration;
import java.util.List;

public class AddressConfigurationCreator
extends Creator<AddressConfiguration> {
    private AddressConfiguration.Type type;
    private String address;
    private String friendlyName;
    private Boolean autoCreationEnabled;
    private AddressConfiguration.AutoCreationType autoCreationType;
    private String autoCreationConversationServiceSid;
    private String autoCreationWebhookUrl;
    private AddressConfiguration.Method autoCreationWebhookMethod;
    private List<String> autoCreationWebhookFilters;
    private String autoCreationStudioFlowSid;
    private Integer autoCreationStudioRetryCount;
    private String addressCountry;

    public AddressConfigurationCreator(AddressConfiguration.Type type, String address) {
        this.type = type;
        this.address = address;
    }

    public AddressConfigurationCreator setType(AddressConfiguration.Type type) {
        this.type = type;
        return this;
    }

    public AddressConfigurationCreator setAddress(String address) {
        this.address = address;
        return this;
    }

    public AddressConfigurationCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AddressConfigurationCreator setAutoCreationEnabled(Boolean autoCreationEnabled) {
        this.autoCreationEnabled = autoCreationEnabled;
        return this;
    }

    public AddressConfigurationCreator setAutoCreationType(AddressConfiguration.AutoCreationType autoCreationType) {
        this.autoCreationType = autoCreationType;
        return this;
    }

    public AddressConfigurationCreator setAutoCreationConversationServiceSid(String autoCreationConversationServiceSid) {
        this.autoCreationConversationServiceSid = autoCreationConversationServiceSid;
        return this;
    }

    public AddressConfigurationCreator setAutoCreationWebhookUrl(String autoCreationWebhookUrl) {
        this.autoCreationWebhookUrl = autoCreationWebhookUrl;
        return this;
    }

    public AddressConfigurationCreator setAutoCreationWebhookMethod(AddressConfiguration.Method autoCreationWebhookMethod) {
        this.autoCreationWebhookMethod = autoCreationWebhookMethod;
        return this;
    }

    public AddressConfigurationCreator setAutoCreationWebhookFilters(List<String> autoCreationWebhookFilters) {
        this.autoCreationWebhookFilters = autoCreationWebhookFilters;
        return this;
    }

    public AddressConfigurationCreator setAutoCreationWebhookFilters(String autoCreationWebhookFilters) {
        return this.setAutoCreationWebhookFilters(Promoter.listOfOne(autoCreationWebhookFilters));
    }

    public AddressConfigurationCreator setAutoCreationStudioFlowSid(String autoCreationStudioFlowSid) {
        this.autoCreationStudioFlowSid = autoCreationStudioFlowSid;
        return this;
    }

    public AddressConfigurationCreator setAutoCreationStudioRetryCount(Integer autoCreationStudioRetryCount) {
        this.autoCreationStudioRetryCount = autoCreationStudioRetryCount;
        return this;
    }

    public AddressConfigurationCreator setAddressCountry(String addressCountry) {
        this.addressCountry = addressCountry;
        return this;
    }

    @Override
    public AddressConfiguration create(TwilioRestClient client) {
        String path = "/v1/Configuration/Addresses";
        path = path.replace("{Type}", this.type.toString());
        path = path.replace("{Address}", this.address.toString());
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AddressConfiguration creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AddressConfiguration.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.type != null) {
            request.addPostParam("Type", this.type.toString());
        }
        if (this.address != null) {
            request.addPostParam("Address", this.address);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.autoCreationEnabled != null) {
            request.addPostParam("AutoCreation.Enabled", this.autoCreationEnabled.toString());
        }
        if (this.autoCreationType != null) {
            request.addPostParam("AutoCreation.Type", this.autoCreationType.toString());
        }
        if (this.autoCreationConversationServiceSid != null) {
            request.addPostParam("AutoCreation.ConversationServiceSid", this.autoCreationConversationServiceSid);
        }
        if (this.autoCreationWebhookUrl != null) {
            request.addPostParam("AutoCreation.WebhookUrl", this.autoCreationWebhookUrl);
        }
        if (this.autoCreationWebhookMethod != null) {
            request.addPostParam("AutoCreation.WebhookMethod", this.autoCreationWebhookMethod.toString());
        }
        if (this.autoCreationWebhookFilters != null) {
            for (String prop : this.autoCreationWebhookFilters) {
                request.addPostParam("AutoCreation.WebhookFilters", prop);
            }
        }
        if (this.autoCreationStudioFlowSid != null) {
            request.addPostParam("AutoCreation.StudioFlowSid", this.autoCreationStudioFlowSid);
        }
        if (this.autoCreationStudioRetryCount != null) {
            request.addPostParam("AutoCreation.StudioRetryCount", this.autoCreationStudioRetryCount.toString());
        }
        if (this.addressCountry != null) {
            request.addPostParam("AddressCountry", this.addressCountry);
        }
    }
}

