/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.content.v1.content;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.content.v1.content.ApprovalFetchFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ApprovalFetch
extends Resource {
    private static final long serialVersionUID = 266557741388539L;
    private final String sid;
    private final String accountSid;
    private final Map<String, Object> whatsapp;
    private final URI url;

    public static ApprovalFetchFetcher fetcher(String pathContentSid) {
        return new ApprovalFetchFetcher(pathContentSid);
    }

    public static ApprovalFetch fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ApprovalFetch.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ApprovalFetch fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ApprovalFetch.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ApprovalFetch(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="whatsapp") Map<String, Object> whatsapp, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.whatsapp = whatsapp;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Map<String, Object> getWhatsapp() {
        return this.whatsapp;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApprovalFetch other = (ApprovalFetch)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.whatsapp, other.whatsapp) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.whatsapp, this.url);
    }

    public String toString() {
        return "ApprovalFetch(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", whatsapp=" + this.getWhatsapp() + ", url=" + this.getUrl() + ")";
    }
}

