/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.content.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.content.v1.LegacyContentReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LegacyContent
extends Resource {
    private static final long serialVersionUID = 57833124155343L;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final String language;
    private final Map<String, Object> variables;
    private final Map<String, Object> types;
    private final String legacyTemplateName;
    private final String legacyBody;
    private final URI url;

    public static LegacyContentReader reader() {
        return new LegacyContentReader();
    }

    public static LegacyContent fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, LegacyContent.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static LegacyContent fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, LegacyContent.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private LegacyContent(@JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="language") String language, @JsonProperty(value="variables") Map<String, Object> variables, @JsonProperty(value="types") Map<String, Object> types, @JsonProperty(value="legacy_template_name") String legacyTemplateName, @JsonProperty(value="legacy_body") String legacyBody, @JsonProperty(value="url") URI url) {
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.language = language;
        this.variables = variables;
        this.types = types;
        this.legacyTemplateName = legacyTemplateName;
        this.legacyBody = legacyBody;
        this.url = url;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getLanguage() {
        return this.language;
    }

    public final Map<String, Object> getVariables() {
        return this.variables;
    }

    public final Map<String, Object> getTypes() {
        return this.types;
    }

    public final String getLegacyTemplateName() {
        return this.legacyTemplateName;
    }

    public final String getLegacyBody() {
        return this.legacyBody;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacyContent other = (LegacyContent)o;
        return Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.language, other.language) && Objects.equals(this.variables, other.variables) && Objects.equals(this.types, other.types) && Objects.equals(this.legacyTemplateName, other.legacyTemplateName) && Objects.equals(this.legacyBody, other.legacyBody) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.dateCreated, this.dateUpdated, this.sid, this.accountSid, this.friendlyName, this.language, this.variables, this.types, this.legacyTemplateName, this.legacyBody, this.url);
    }

    public String toString() {
        return "LegacyContent(dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", friendlyName=" + this.getFriendlyName() + ", language=" + this.getLanguage() + ", variables=" + this.getVariables() + ", types=" + this.getTypes() + ", legacyTemplateName=" + this.getLegacyTemplateName() + ", legacyBody=" + this.getLegacyBody() + ", url=" + this.getUrl() + ")";
    }
}

