/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.content.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.content.v1.ContentCreator;
import com.twilio.rest.content.v1.ContentDeleter;
import com.twilio.rest.content.v1.ContentFetcher;
import com.twilio.rest.content.v1.ContentReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Content
extends Resource {
    private static final long serialVersionUID = 58899890984300L;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final String language;
    private final Map<String, Object> variables;
    private final Map<String, Object> types;
    private final URI url;
    private final Map<String, String> links;

    public static ContentCreator creator(ContentCreateRequest contentCreateRequest) {
        return new ContentCreator(contentCreateRequest);
    }

    public static ContentDeleter deleter(String pathSid) {
        return new ContentDeleter(pathSid);
    }

    public static ContentFetcher fetcher(String pathSid) {
        return new ContentFetcher(pathSid);
    }

    public static ContentReader reader() {
        return new ContentReader();
    }

    public static Content fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Content.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Content fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Content.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static String toJson(Object object, ObjectMapper mapper) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Content(@JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="language") String language, @JsonProperty(value="variables") Map<String, Object> variables, @JsonProperty(value="types") Map<String, Object> types, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.language = language;
        this.variables = variables;
        this.types = types;
        this.url = url;
        this.links = links;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getLanguage() {
        return this.language;
    }

    public final Map<String, Object> getVariables() {
        return this.variables;
    }

    public final Map<String, Object> getTypes() {
        return this.types;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Content other = (Content)o;
        return Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.language, other.language) && Objects.equals(this.variables, other.variables) && Objects.equals(this.types, other.types) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.dateCreated, this.dateUpdated, this.sid, this.accountSid, this.friendlyName, this.language, this.variables, this.types, this.url, this.links);
    }

    public String toString() {
        return "Content(dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", friendlyName=" + this.getFriendlyName() + ", language=" + this.getLanguage() + ", variables=" + this.getVariables() + ", types=" + this.getTypes() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }

    public static enum AuthenticationActionType {
        COPY_CODE("COPY_CODE");

        private final String value;

        private AuthenticationActionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static AuthenticationActionType forValue(String value) {
            return (AuthenticationActionType)Promoter.enumFromString((String)value, (Enum[])AuthenticationActionType.values());
        }
    }

    public static enum CardActionType {
        URL("URL"),
        PHONE_NUMBER("PHONE_NUMBER"),
        QUICK_REPLY("QUICK_REPLY");

        private final String value;

        private CardActionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static CardActionType forValue(String value) {
            return (CardActionType)Promoter.enumFromString((String)value, (Enum[])CardActionType.values());
        }
    }

    public static enum QuickReplyActionType {
        QUICK_REPLY("QUICK_REPLY");

        private final String value;

        private QuickReplyActionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static QuickReplyActionType forValue(String value) {
            return (QuickReplyActionType)Promoter.enumFromString((String)value, (Enum[])QuickReplyActionType.values());
        }
    }

    public static enum CallToActionActionType {
        URL("URL"),
        PHONE_NUMBER("PHONE_NUMBER");

        private final String value;

        private CallToActionActionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static CallToActionActionType forValue(String value) {
            return (CallToActionActionType)Promoter.enumFromString((String)value, (Enum[])CallToActionActionType.values());
        }
    }

    public static class ContentCreateRequest {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="friendly_name")
        private String friendlyName;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="variables")
        private Map<String, String> variables;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="language")
        private String language;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="types")
        private Types types;

        public ContentCreateRequest(String language, Types types) {
            this.language = language;
            this.types = types;
        }

        public static ContentCreateRequest fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, ContentCreateRequest.class);
        }

        public String toString() {
            return "Content.ContentCreateRequest(friendlyName=" + this.getFriendlyName() + ", variables=" + this.getVariables() + ", language=" + this.getLanguage() + ", types=" + this.getTypes() + ")";
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        @JsonProperty(value="friendly_name")
        public void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public Map<String, String> getVariables() {
            return this.variables;
        }

        @JsonProperty(value="variables")
        public void setVariables(Map<String, String> variables) {
            this.variables = variables;
        }

        public String getLanguage() {
            return this.language;
        }

        @JsonProperty(value="language")
        public void setLanguage(String language) {
            this.language = language;
        }

        public Types getTypes() {
            return this.types;
        }

        @JsonProperty(value="types")
        public void setTypes(Types types) {
            this.types = types;
        }
    }

    public static class Types {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="twilio/text")
        private TwilioText twilioText;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="twilio/media")
        private TwilioMedia twilioMedia;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="twilio/location")
        private TwilioLocation twilioLocation;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="twilio/list-picker")
        private TwilioListPicker twilioListPicker;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="twilio/call-to-action")
        private TwilioCallToAction twilioCallToAction;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="twilio/quick-reply")
        private TwilioQuickReply twilioQuickReply;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="twilio/card")
        private TwilioCard twilioCard;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="twilio/catalog")
        private TwilioCatalog twilioCatalog;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="whatsapp/card")
        private WhatsappCard whatsappCard;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="whatsapp/authentication")
        private WhatsappAuthentication whatsappAuthentication;

        public static Types fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, Types.class);
        }

        public String toString() {
            return "Content.Types(twilioText=" + this.getTwilioText() + ", twilioMedia=" + this.getTwilioMedia() + ", twilioLocation=" + this.getTwilioLocation() + ", twilioListPicker=" + this.getTwilioListPicker() + ", twilioCallToAction=" + this.getTwilioCallToAction() + ", twilioQuickReply=" + this.getTwilioQuickReply() + ", twilioCard=" + this.getTwilioCard() + ", twilioCatalog=" + this.getTwilioCatalog() + ", whatsappCard=" + this.getWhatsappCard() + ", whatsappAuthentication=" + this.getWhatsappAuthentication() + ")";
        }

        public TwilioText getTwilioText() {
            return this.twilioText;
        }

        @JsonProperty(value="twilio/text")
        public void setTwilioText(TwilioText twilioText) {
            this.twilioText = twilioText;
        }

        public TwilioMedia getTwilioMedia() {
            return this.twilioMedia;
        }

        @JsonProperty(value="twilio/media")
        public void setTwilioMedia(TwilioMedia twilioMedia) {
            this.twilioMedia = twilioMedia;
        }

        public TwilioLocation getTwilioLocation() {
            return this.twilioLocation;
        }

        @JsonProperty(value="twilio/location")
        public void setTwilioLocation(TwilioLocation twilioLocation) {
            this.twilioLocation = twilioLocation;
        }

        public TwilioListPicker getTwilioListPicker() {
            return this.twilioListPicker;
        }

        @JsonProperty(value="twilio/list-picker")
        public void setTwilioListPicker(TwilioListPicker twilioListPicker) {
            this.twilioListPicker = twilioListPicker;
        }

        public TwilioCallToAction getTwilioCallToAction() {
            return this.twilioCallToAction;
        }

        @JsonProperty(value="twilio/call-to-action")
        public void setTwilioCallToAction(TwilioCallToAction twilioCallToAction) {
            this.twilioCallToAction = twilioCallToAction;
        }

        public TwilioQuickReply getTwilioQuickReply() {
            return this.twilioQuickReply;
        }

        @JsonProperty(value="twilio/quick-reply")
        public void setTwilioQuickReply(TwilioQuickReply twilioQuickReply) {
            this.twilioQuickReply = twilioQuickReply;
        }

        public TwilioCard getTwilioCard() {
            return this.twilioCard;
        }

        @JsonProperty(value="twilio/card")
        public void setTwilioCard(TwilioCard twilioCard) {
            this.twilioCard = twilioCard;
        }

        public TwilioCatalog getTwilioCatalog() {
            return this.twilioCatalog;
        }

        @JsonProperty(value="twilio/catalog")
        public void setTwilioCatalog(TwilioCatalog twilioCatalog) {
            this.twilioCatalog = twilioCatalog;
        }

        public WhatsappCard getWhatsappCard() {
            return this.whatsappCard;
        }

        @JsonProperty(value="whatsapp/card")
        public void setWhatsappCard(WhatsappCard whatsappCard) {
            this.whatsappCard = whatsappCard;
        }

        public WhatsappAuthentication getWhatsappAuthentication() {
            return this.whatsappAuthentication;
        }

        @JsonProperty(value="whatsapp/authentication")
        public void setWhatsappAuthentication(WhatsappAuthentication whatsappAuthentication) {
            this.whatsappAuthentication = whatsappAuthentication;
        }
    }

    public static class WhatsappAuthentication {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="add_security_recommendation")
        private Boolean addSecurityRecommendation;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="code_expiration_minutes")
        private BigDecimal codeExpirationMinutes;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="actions")
        private List<AuthenticationAction> actions;

        public static WhatsappAuthentication fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, WhatsappAuthentication.class);
        }

        public String toString() {
            return "Content.WhatsappAuthentication(addSecurityRecommendation=" + this.getAddSecurityRecommendation() + ", codeExpirationMinutes=" + this.getCodeExpirationMinutes() + ", actions=" + this.getActions() + ")";
        }

        public Boolean getAddSecurityRecommendation() {
            return this.addSecurityRecommendation;
        }

        @JsonProperty(value="add_security_recommendation")
        public void setAddSecurityRecommendation(Boolean addSecurityRecommendation) {
            this.addSecurityRecommendation = addSecurityRecommendation;
        }

        public BigDecimal getCodeExpirationMinutes() {
            return this.codeExpirationMinutes;
        }

        @JsonProperty(value="code_expiration_minutes")
        public void setCodeExpirationMinutes(BigDecimal codeExpirationMinutes) {
            this.codeExpirationMinutes = codeExpirationMinutes;
        }

        public List<AuthenticationAction> getActions() {
            return this.actions;
        }

        @JsonProperty(value="actions")
        public void setActions(List<AuthenticationAction> actions) {
            this.actions = actions;
        }
    }

    public static class AuthenticationAction {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="type")
        private AuthenticationActionType type;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="copy_code_text")
        private String copyCodeText;

        public static AuthenticationAction fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, AuthenticationAction.class);
        }

        public String toString() {
            return "Content.AuthenticationAction(type=" + (Object)((Object)this.getType()) + ", copyCodeText=" + this.getCopyCodeText() + ")";
        }

        public AuthenticationActionType getType() {
            return this.type;
        }

        @JsonProperty(value="type")
        public void setType(AuthenticationActionType type) {
            this.type = type;
        }

        public String getCopyCodeText() {
            return this.copyCodeText;
        }

        @JsonProperty(value="copy_code_text")
        public void setCopyCodeText(String copyCodeText) {
            this.copyCodeText = copyCodeText;
        }
    }

    public static class WhatsappCard {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="body")
        private String body;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="footer")
        private String footer;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="media")
        private List<String> media;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="header_text")
        private String headerText;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="actions")
        private List<CardAction> actions;

        public static WhatsappCard fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, WhatsappCard.class);
        }

        public String toString() {
            return "Content.WhatsappCard(body=" + this.getBody() + ", footer=" + this.getFooter() + ", media=" + this.getMedia() + ", headerText=" + this.getHeaderText() + ", actions=" + this.getActions() + ")";
        }

        public String getBody() {
            return this.body;
        }

        @JsonProperty(value="body")
        public void setBody(String body) {
            this.body = body;
        }

        public String getFooter() {
            return this.footer;
        }

        @JsonProperty(value="footer")
        public void setFooter(String footer) {
            this.footer = footer;
        }

        public List<String> getMedia() {
            return this.media;
        }

        @JsonProperty(value="media")
        public void setMedia(List<String> media) {
            this.media = media;
        }

        public String getHeaderText() {
            return this.headerText;
        }

        @JsonProperty(value="header_text")
        public void setHeaderText(String headerText) {
            this.headerText = headerText;
        }

        public List<CardAction> getActions() {
            return this.actions;
        }

        @JsonProperty(value="actions")
        public void setActions(List<CardAction> actions) {
            this.actions = actions;
        }
    }

    public static class TwilioCatalog {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="title")
        private String title;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="body")
        private String body;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="subtitle")
        private String subtitle;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="id")
        private String id;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="items")
        private List<CatalogItem> items;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="dynamic_items")
        private String dynamicItems;

        public static TwilioCatalog fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, TwilioCatalog.class);
        }

        public String toString() {
            return "Content.TwilioCatalog(title=" + this.getTitle() + ", body=" + this.getBody() + ", subtitle=" + this.getSubtitle() + ", id=" + this.getId() + ", items=" + this.getItems() + ", dynamicItems=" + this.getDynamicItems() + ")";
        }

        public String getTitle() {
            return this.title;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        public String getBody() {
            return this.body;
        }

        @JsonProperty(value="body")
        public void setBody(String body) {
            this.body = body;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        @JsonProperty(value="subtitle")
        public void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        public String getId() {
            return this.id;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        public List<CatalogItem> getItems() {
            return this.items;
        }

        @JsonProperty(value="items")
        public void setItems(List<CatalogItem> items) {
            this.items = items;
        }

        public String getDynamicItems() {
            return this.dynamicItems;
        }

        @JsonProperty(value="dynamic_items")
        public void setDynamicItems(String dynamicItems) {
            this.dynamicItems = dynamicItems;
        }
    }

    public static class CatalogItem {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="id")
        private String id;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="section_title")
        private String sectionTitle;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="name")
        private String name;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="media_url")
        private String mediaUrl;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="price")
        private BigDecimal price;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="description")
        private String description;

        public static CatalogItem fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, CatalogItem.class);
        }

        public String toString() {
            return "Content.CatalogItem(id=" + this.getId() + ", sectionTitle=" + this.getSectionTitle() + ", name=" + this.getName() + ", mediaUrl=" + this.getMediaUrl() + ", price=" + this.getPrice() + ", description=" + this.getDescription() + ")";
        }

        public String getId() {
            return this.id;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        public String getSectionTitle() {
            return this.sectionTitle;
        }

        @JsonProperty(value="section_title")
        public void setSectionTitle(String sectionTitle) {
            this.sectionTitle = sectionTitle;
        }

        public String getName() {
            return this.name;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        public String getMediaUrl() {
            return this.mediaUrl;
        }

        @JsonProperty(value="media_url")
        public void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        @JsonProperty(value="price")
        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class TwilioCard {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="title")
        private String title;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="subtitle")
        private String subtitle;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="media")
        private List<String> media;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="actions")
        private List<CardAction> actions;

        public static TwilioCard fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, TwilioCard.class);
        }

        public String toString() {
            return "Content.TwilioCard(title=" + this.getTitle() + ", subtitle=" + this.getSubtitle() + ", media=" + this.getMedia() + ", actions=" + this.getActions() + ")";
        }

        public String getTitle() {
            return this.title;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        @JsonProperty(value="subtitle")
        public void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        public List<String> getMedia() {
            return this.media;
        }

        @JsonProperty(value="media")
        public void setMedia(List<String> media) {
            this.media = media;
        }

        public List<CardAction> getActions() {
            return this.actions;
        }

        @JsonProperty(value="actions")
        public void setActions(List<CardAction> actions) {
            this.actions = actions;
        }
    }

    public static class CardAction {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="type")
        private CardActionType type;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="title")
        private String title;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="url")
        private String url;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="phone")
        private String phone;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="id")
        private String id;

        public static CardAction fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, CardAction.class);
        }

        public String toString() {
            return "Content.CardAction(type=" + (Object)((Object)this.getType()) + ", title=" + this.getTitle() + ", url=" + this.getUrl() + ", phone=" + this.getPhone() + ", id=" + this.getId() + ")";
        }

        public CardActionType getType() {
            return this.type;
        }

        @JsonProperty(value="type")
        public void setType(CardActionType type) {
            this.type = type;
        }

        public String getTitle() {
            return this.title;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        public String getUrl() {
            return this.url;
        }

        @JsonProperty(value="url")
        public void setUrl(String url) {
            this.url = url;
        }

        public String getPhone() {
            return this.phone;
        }

        @JsonProperty(value="phone")
        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getId() {
            return this.id;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }
    }

    public static class TwilioQuickReply {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="body")
        private String body;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="actions")
        private List<QuickReplyAction> actions;

        public static TwilioQuickReply fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, TwilioQuickReply.class);
        }

        public String toString() {
            return "Content.TwilioQuickReply(body=" + this.getBody() + ", actions=" + this.getActions() + ")";
        }

        public String getBody() {
            return this.body;
        }

        @JsonProperty(value="body")
        public void setBody(String body) {
            this.body = body;
        }

        public List<QuickReplyAction> getActions() {
            return this.actions;
        }

        @JsonProperty(value="actions")
        public void setActions(List<QuickReplyAction> actions) {
            this.actions = actions;
        }
    }

    public static class QuickReplyAction {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="type")
        private QuickReplyActionType type;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="title")
        private String title;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="id")
        private String id;

        public static QuickReplyAction fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, QuickReplyAction.class);
        }

        public String toString() {
            return "Content.QuickReplyAction(type=" + (Object)((Object)this.getType()) + ", title=" + this.getTitle() + ", id=" + this.getId() + ")";
        }

        public QuickReplyActionType getType() {
            return this.type;
        }

        @JsonProperty(value="type")
        public void setType(QuickReplyActionType type) {
            this.type = type;
        }

        public String getTitle() {
            return this.title;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        public String getId() {
            return this.id;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }
    }

    public static class TwilioCallToAction {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="body")
        private String body;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="actions")
        private List<CallToActionAction> actions;

        public static TwilioCallToAction fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, TwilioCallToAction.class);
        }

        public String toString() {
            return "Content.TwilioCallToAction(body=" + this.getBody() + ", actions=" + this.getActions() + ")";
        }

        public String getBody() {
            return this.body;
        }

        @JsonProperty(value="body")
        public void setBody(String body) {
            this.body = body;
        }

        public List<CallToActionAction> getActions() {
            return this.actions;
        }

        @JsonProperty(value="actions")
        public void setActions(List<CallToActionAction> actions) {
            this.actions = actions;
        }
    }

    public static class CallToActionAction {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="type")
        private CallToActionActionType type;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="title")
        private String title;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="url")
        private String url;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="phone")
        private String phone;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="id")
        private String id;

        public static CallToActionAction fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, CallToActionAction.class);
        }

        public String toString() {
            return "Content.CallToActionAction(type=" + (Object)((Object)this.getType()) + ", title=" + this.getTitle() + ", url=" + this.getUrl() + ", phone=" + this.getPhone() + ", id=" + this.getId() + ")";
        }

        public CallToActionActionType getType() {
            return this.type;
        }

        @JsonProperty(value="type")
        public void setType(CallToActionActionType type) {
            this.type = type;
        }

        public String getTitle() {
            return this.title;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        public String getUrl() {
            return this.url;
        }

        @JsonProperty(value="url")
        public void setUrl(String url) {
            this.url = url;
        }

        public String getPhone() {
            return this.phone;
        }

        @JsonProperty(value="phone")
        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getId() {
            return this.id;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }
    }

    public static class TwilioListPicker {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="body")
        private String body;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="button")
        private String button;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="items")
        private List<ListItem> items;

        public static TwilioListPicker fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, TwilioListPicker.class);
        }

        public String toString() {
            return "Content.TwilioListPicker(body=" + this.getBody() + ", button=" + this.getButton() + ", items=" + this.getItems() + ")";
        }

        public String getBody() {
            return this.body;
        }

        @JsonProperty(value="body")
        public void setBody(String body) {
            this.body = body;
        }

        public String getButton() {
            return this.button;
        }

        @JsonProperty(value="button")
        public void setButton(String button) {
            this.button = button;
        }

        public List<ListItem> getItems() {
            return this.items;
        }

        @JsonProperty(value="items")
        public void setItems(List<ListItem> items) {
            this.items = items;
        }
    }

    public static class ListItem {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="id")
        private String id;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="item")
        private String item;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="description")
        private String description;

        public static ListItem fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, ListItem.class);
        }

        public String toString() {
            return "Content.ListItem(id=" + this.getId() + ", item=" + this.getItem() + ", description=" + this.getDescription() + ")";
        }

        public String getId() {
            return this.id;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        public String getItem() {
            return this.item;
        }

        @JsonProperty(value="item")
        public void setItem(String item) {
            this.item = item;
        }

        public String getDescription() {
            return this.description;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class TwilioLocation {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="latitude")
        private BigDecimal latitude;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="longitude")
        private BigDecimal longitude;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="label")
        private String label;

        public static TwilioLocation fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, TwilioLocation.class);
        }

        public String toString() {
            return "Content.TwilioLocation(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", label=" + this.getLabel() + ")";
        }

        public BigDecimal getLatitude() {
            return this.latitude;
        }

        @JsonProperty(value="latitude")
        public void setLatitude(BigDecimal latitude) {
            this.latitude = latitude;
        }

        public BigDecimal getLongitude() {
            return this.longitude;
        }

        @JsonProperty(value="longitude")
        public void setLongitude(BigDecimal longitude) {
            this.longitude = longitude;
        }

        public String getLabel() {
            return this.label;
        }

        @JsonProperty(value="label")
        public void setLabel(String label) {
            this.label = label;
        }
    }

    public static class TwilioMedia {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="body")
        private String body;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="media")
        private List<String> media;

        public static TwilioMedia fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, TwilioMedia.class);
        }

        public String toString() {
            return "Content.TwilioMedia(body=" + this.getBody() + ", media=" + this.getMedia() + ")";
        }

        public String getBody() {
            return this.body;
        }

        @JsonProperty(value="body")
        public void setBody(String body) {
            this.body = body;
        }

        public List<String> getMedia() {
            return this.media;
        }

        @JsonProperty(value="media")
        public void setMedia(List<String> media) {
            this.media = media;
        }
    }

    public static class TwilioText {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty(value="body")
        private String body;

        public static TwilioText fromJson(String jsonString, ObjectMapper mapper) throws IOException {
            return mapper.readValue(jsonString, TwilioText.class);
        }

        public String toString() {
            return "Content.TwilioText(body=" + this.getBody() + ")";
        }

        public String getBody() {
            return this.body;
        }

        @JsonProperty(value="body")
        public void setBody(String body) {
            this.body = body;
        }
    }
}

