/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.chat.v3.ChannelUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Channel
extends Resource {
    private static final long serialVersionUID = 62753936180140L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String friendlyName;
    private final String uniqueName;
    private final String attributes;
    private final ChannelType type;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String createdBy;
    private final Integer membersCount;
    private final Integer messagesCount;
    private final String messagingServiceSid;
    private final URI url;

    public static ChannelUpdater updater(String pathServiceSid, String pathSid) {
        return new ChannelUpdater(pathServiceSid, pathSid);
    }

    public static Channel fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Channel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Channel fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Channel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Channel(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="type") ChannelType type, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="created_by") String createdBy, @JsonProperty(value="members_count") Integer membersCount, @JsonProperty(value="messages_count") Integer messagesCount, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.friendlyName = friendlyName;
        this.uniqueName = uniqueName;
        this.attributes = attributes;
        this.type = type;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.createdBy = createdBy;
        this.membersCount = membersCount;
        this.messagesCount = messagesCount;
        this.messagingServiceSid = messagingServiceSid;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final ChannelType getType() {
        return this.type;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getCreatedBy() {
        return this.createdBy;
    }

    public final Integer getMembersCount() {
        return this.membersCount;
    }

    public final Integer getMessagesCount() {
        return this.messagesCount;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel other = (Channel)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.attributes, other.attributes) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals(this.membersCount, other.membersCount) && Objects.equals(this.messagesCount, other.messagesCount) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.friendlyName, this.uniqueName, this.attributes, this.type, this.dateCreated, this.dateUpdated, this.createdBy, this.membersCount, this.messagesCount, this.messagingServiceSid, this.url});
    }

    public String toString() {
        return "Channel(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", friendlyName=" + this.getFriendlyName() + ", uniqueName=" + this.getUniqueName() + ", attributes=" + this.getAttributes() + ", type=" + (Object)((Object)this.getType()) + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", createdBy=" + this.getCreatedBy() + ", membersCount=" + this.getMembersCount() + ", messagesCount=" + this.getMessagesCount() + ", messagingServiceSid=" + this.getMessagingServiceSid() + ", url=" + this.getUrl() + ")";
    }

    public static enum ChannelType {
        PUBLIC("public"),
        PRIVATE("private");

        private final String value;

        private ChannelType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ChannelType forValue(String value) {
            return (ChannelType)Promoter.enumFromString((String)value, (Enum[])ChannelType.values());
        }
    }

    public static enum WebhookEnabledType {
        TRUE("true"),
        FALSE("false");

        private final String value;

        private WebhookEnabledType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static WebhookEnabledType forValue(String value) {
            return (WebhookEnabledType)Promoter.enumFromString((String)value, (Enum[])WebhookEnabledType.values());
        }
    }
}

