/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v2.service.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.chat.v2.service.user.UserBindingDeleter;
import com.twilio.rest.chat.v2.service.user.UserBindingFetcher;
import com.twilio.rest.chat.v2.service.user.UserBindingReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UserBinding
extends Resource {
    private static final long serialVersionUID = 252068300768529L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String endpoint;
    private final String identity;
    private final String userSid;
    private final String credentialSid;
    private final BindingType bindingType;
    private final List<String> messageTypes;
    private final URI url;

    public static UserBindingDeleter deleter(String pathServiceSid, String pathUserSid, String pathSid) {
        return new UserBindingDeleter(pathServiceSid, pathUserSid, pathSid);
    }

    public static UserBindingFetcher fetcher(String pathServiceSid, String pathUserSid, String pathSid) {
        return new UserBindingFetcher(pathServiceSid, pathUserSid, pathSid);
    }

    public static UserBindingReader reader(String pathServiceSid, String pathUserSid) {
        return new UserBindingReader(pathServiceSid, pathUserSid);
    }

    public static UserBinding fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UserBinding.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static UserBinding fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UserBinding.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private UserBinding(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="endpoint") String endpoint, @JsonProperty(value="identity") String identity, @JsonProperty(value="user_sid") String userSid, @JsonProperty(value="credential_sid") String credentialSid, @JsonProperty(value="binding_type") BindingType bindingType, @JsonProperty(value="message_types") List<String> messageTypes, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.endpoint = endpoint;
        this.identity = identity;
        this.userSid = userSid;
        this.credentialSid = credentialSid;
        this.bindingType = bindingType;
        this.messageTypes = messageTypes;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getEndpoint() {
        return this.endpoint;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getUserSid() {
        return this.userSid;
    }

    public final String getCredentialSid() {
        return this.credentialSid;
    }

    public final BindingType getBindingType() {
        return this.bindingType;
    }

    public final List<String> getMessageTypes() {
        return this.messageTypes;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserBinding other = (UserBinding)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.identity, other.identity) && Objects.equals(this.userSid, other.userSid) && Objects.equals(this.credentialSid, other.credentialSid) && Objects.equals((Object)this.bindingType, (Object)other.bindingType) && Objects.equals(this.messageTypes, other.messageTypes) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.dateCreated, this.dateUpdated, this.endpoint, this.identity, this.userSid, this.credentialSid, this.bindingType, this.messageTypes, this.url});
    }

    public String toString() {
        return "UserBinding(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", endpoint=" + this.getEndpoint() + ", identity=" + this.getIdentity() + ", userSid=" + this.getUserSid() + ", credentialSid=" + this.getCredentialSid() + ", bindingType=" + (Object)((Object)this.getBindingType()) + ", messageTypes=" + this.getMessageTypes() + ", url=" + this.getUrl() + ")";
    }

    public static enum BindingType {
        GCM("gcm"),
        APN("apn"),
        FCM("fcm");

        private final String value;

        private BindingType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static BindingType forValue(String value) {
            return (BindingType)Promoter.enumFromString((String)value, (Enum[])BindingType.values());
        }
    }
}

