/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v2.service.channel;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v2.service.channel.Member;
import java.time.ZonedDateTime;

public class MemberUpdater
extends Updater<Member> {
    private String pathServiceSid;
    private String pathChannelSid;
    private String pathSid;
    private Member.WebhookEnabledType xTwilioWebhookEnabled;
    private String roleSid;
    private Integer lastConsumedMessageIndex;
    private ZonedDateTime lastConsumptionTimestamp;
    private ZonedDateTime dateCreated;
    private ZonedDateTime dateUpdated;
    private String attributes;

    public MemberUpdater(String pathServiceSid, String pathChannelSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathChannelSid = pathChannelSid;
        this.pathSid = pathSid;
    }

    public MemberUpdater setXTwilioWebhookEnabled(Member.WebhookEnabledType xTwilioWebhookEnabled) {
        this.xTwilioWebhookEnabled = xTwilioWebhookEnabled;
        return this;
    }

    public MemberUpdater setRoleSid(String roleSid) {
        this.roleSid = roleSid;
        return this;
    }

    public MemberUpdater setLastConsumedMessageIndex(Integer lastConsumedMessageIndex) {
        this.lastConsumedMessageIndex = lastConsumedMessageIndex;
        return this;
    }

    public MemberUpdater setLastConsumptionTimestamp(ZonedDateTime lastConsumptionTimestamp) {
        this.lastConsumptionTimestamp = lastConsumptionTimestamp;
        return this;
    }

    public MemberUpdater setDateCreated(ZonedDateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public MemberUpdater setDateUpdated(ZonedDateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public MemberUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public Member update(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Channels/{ChannelSid}/Members/{Sid}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{ChannelSid}", this.pathChannelSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.CHAT.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Member update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Member.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.roleSid != null) {
            request.addPostParam("RoleSid", this.roleSid);
        }
        if (this.lastConsumedMessageIndex != null) {
            request.addPostParam("LastConsumedMessageIndex", this.lastConsumedMessageIndex.toString());
        }
        if (this.lastConsumptionTimestamp != null) {
            request.addPostParam("LastConsumptionTimestamp", this.lastConsumptionTimestamp.toInstant().toString());
        }
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toInstant().toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toInstant().toString());
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioWebhookEnabled != null) {
            request.addHeaderParam("X-Twilio-Webhook-Enabled", this.xTwilioWebhookEnabled.toString());
        }
    }
}

