/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v1.service.channel;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v1.service.channel.Message;

public class MessageCreator
extends Creator<Message> {
    private String pathServiceSid;
    private String pathChannelSid;
    private String body;
    private String from;
    private String attributes;

    public MessageCreator(String pathServiceSid, String pathChannelSid, String body) {
        this.pathServiceSid = pathServiceSid;
        this.pathChannelSid = pathChannelSid;
        this.body = body;
    }

    public MessageCreator setBody(String body) {
        this.body = body;
        return this;
    }

    public MessageCreator setFrom(String from) {
        this.from = from;
        return this;
    }

    public MessageCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public Message create(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Channels/{ChannelSid}/Messages";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{ChannelSid}", this.pathChannelSid.toString());
        path = path.replace("{Body}", this.body.toString());
        Request request = new Request(HttpMethod.POST, Domains.CHAT.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Message creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Message.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.body != null) {
            request.addPostParam("Body", this.body);
        }
        if (this.from != null) {
            request.addPostParam("From", this.from);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
    }
}

