/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.chat.v1.service.UserCreator;
import com.twilio.rest.chat.v1.service.UserDeleter;
import com.twilio.rest.chat.v1.service.UserFetcher;
import com.twilio.rest.chat.v1.service.UserReader;
import com.twilio.rest.chat.v1.service.UserUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class User
extends Resource {
    private static final long serialVersionUID = 136391609300437L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String attributes;
    private final String friendlyName;
    private final String roleSid;
    private final String identity;
    private final Boolean isOnline;
    private final Boolean isNotifiable;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final Integer joinedChannelsCount;
    private final Map<String, String> links;
    private final URI url;

    public static UserCreator creator(String pathServiceSid, String identity) {
        return new UserCreator(pathServiceSid, identity);
    }

    public static UserDeleter deleter(String pathServiceSid, String pathSid) {
        return new UserDeleter(pathServiceSid, pathSid);
    }

    public static UserFetcher fetcher(String pathServiceSid, String pathSid) {
        return new UserFetcher(pathServiceSid, pathSid);
    }

    public static UserReader reader(String pathServiceSid) {
        return new UserReader(pathServiceSid);
    }

    public static UserUpdater updater(String pathServiceSid, String pathSid) {
        return new UserUpdater(pathServiceSid, pathSid);
    }

    public static User fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, User.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static User fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, User.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private User(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="role_sid") String roleSid, @JsonProperty(value="identity") String identity, @JsonProperty(value="is_online") Boolean isOnline, @JsonProperty(value="is_notifiable") Boolean isNotifiable, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="joined_channels_count") Integer joinedChannelsCount, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.attributes = attributes;
        this.friendlyName = friendlyName;
        this.roleSid = roleSid;
        this.identity = identity;
        this.isOnline = isOnline;
        this.isNotifiable = isNotifiable;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.joinedChannelsCount = joinedChannelsCount;
        this.links = links;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getRoleSid() {
        return this.roleSid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final Boolean getIsOnline() {
        return this.isOnline;
    }

    public final Boolean getIsNotifiable() {
        return this.isNotifiable;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Integer getJoinedChannelsCount() {
        return this.joinedChannelsCount;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User other = (User)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.roleSid, other.roleSid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.isOnline, other.isOnline) && Objects.equals(this.isNotifiable, other.isNotifiable) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.joinedChannelsCount, other.joinedChannelsCount) && Objects.equals(this.links, other.links) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.attributes, this.friendlyName, this.roleSid, this.identity, this.isOnline, this.isNotifiable, this.dateCreated, this.dateUpdated, this.joinedChannelsCount, this.links, this.url);
    }

    public String toString() {
        return "User(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", attributes=" + this.getAttributes() + ", friendlyName=" + this.getFriendlyName() + ", roleSid=" + this.getRoleSid() + ", identity=" + this.getIdentity() + ", isOnline=" + this.getIsOnline() + ", isNotifiable=" + this.getIsNotifiable() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", joinedChannelsCount=" + this.getJoinedChannelsCount() + ", links=" + this.getLinks() + ", url=" + this.getUrl() + ")";
    }
}

