/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.chat.v1.service.RoleCreator;
import com.twilio.rest.chat.v1.service.RoleDeleter;
import com.twilio.rest.chat.v1.service.RoleFetcher;
import com.twilio.rest.chat.v1.service.RoleReader;
import com.twilio.rest.chat.v1.service.RoleUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Role
extends Resource {
    private static final long serialVersionUID = 252065084446046L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String friendlyName;
    private final RoleType type;
    private final List<String> permissions;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static RoleCreator creator(String pathServiceSid, String friendlyName, RoleType type, List<String> permission) {
        return new RoleCreator(pathServiceSid, friendlyName, type, permission);
    }

    public static RoleDeleter deleter(String pathServiceSid, String pathSid) {
        return new RoleDeleter(pathServiceSid, pathSid);
    }

    public static RoleFetcher fetcher(String pathServiceSid, String pathSid) {
        return new RoleFetcher(pathServiceSid, pathSid);
    }

    public static RoleReader reader(String pathServiceSid) {
        return new RoleReader(pathServiceSid);
    }

    public static RoleUpdater updater(String pathServiceSid, String pathSid, List<String> permission) {
        return new RoleUpdater(pathServiceSid, pathSid, permission);
    }

    public static Role fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Role.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Role fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Role.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Role(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="type") RoleType type, @JsonProperty(value="permissions") List<String> permissions, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.friendlyName = friendlyName;
        this.type = type;
        this.permissions = permissions;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final RoleType getType() {
        return this.type;
    }

    public final List<String> getPermissions() {
        return this.permissions;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role other = (Role)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.permissions, other.permissions) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.friendlyName, this.type, this.permissions, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return "Role(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", friendlyName=" + this.getFriendlyName() + ", type=" + (Object)((Object)this.getType()) + ", permissions=" + this.getPermissions() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }

    public static enum RoleType {
        CHANNEL("channel"),
        DEPLOYMENT("deployment");

        private final String value;

        private RoleType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static RoleType forValue(String value) {
            return (RoleType)Promoter.enumFromString((String)value, (Enum[])RoleType.values());
        }
    }
}

