/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.bulkexports.v1.export;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.bulkexports.v1.export.Day;

public class DayFetcher
extends Fetcher<Day> {
    private String pathResourceType;
    private String pathDay;

    public DayFetcher(String pathResourceType, String pathDay) {
        this.pathResourceType = pathResourceType;
        this.pathDay = pathDay;
    }

    @Override
    public Day fetch(TwilioRestClient client) {
        String path = "/v1/Exports/{ResourceType}/Days/{Day}";
        path = path.replace("{ResourceType}", this.pathResourceType.toString());
        path = path.replace("{Day}", this.pathDay.toString());
        Request request = new Request(HttpMethod.GET, Domains.BULKEXPORTS.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Day fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Day.fromJson(response.getStream(), client.getObjectMapper());
    }
}

