/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.bulkexports.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.bulkexports.v1.ExportFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Export
extends Resource {
    private static final long serialVersionUID = 148899891151757L;
    private final String resourceType;
    private final URI url;
    private final Map<String, String> links;

    public static ExportFetcher fetcher(String pathResourceType) {
        return new ExportFetcher(pathResourceType);
    }

    public static Export fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Export.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Export fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Export.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Export(@JsonProperty(value="resource_type") String resourceType, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.resourceType = resourceType;
        this.url = url;
        this.links = links;
    }

    public final String getResourceType() {
        return this.resourceType;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Export other = (Export)o;
        return Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.resourceType, this.url, this.links);
    }

    public String toString() {
        return "Export(resourceType=" + this.getResourceType() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }
}

