/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.usage.record;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.usage.record.Monthly;
import java.time.LocalDate;

public class MonthlyReader
extends Reader<Monthly> {
    private String pathAccountSid;
    private Monthly.Category category;
    private LocalDate startDate;
    private LocalDate endDate;
    private Boolean includeSubaccounts;
    private Integer pageSize;

    public MonthlyReader() {
    }

    public MonthlyReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public MonthlyReader setCategory(Monthly.Category category) {
        this.category = category;
        return this;
    }

    public MonthlyReader setStartDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    public MonthlyReader setEndDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    public MonthlyReader setIncludeSubaccounts(Boolean includeSubaccounts) {
        this.includeSubaccounts = includeSubaccounts;
        return this;
    }

    public MonthlyReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Monthly> read(TwilioRestClient client) {
        return new ResourceSet<Monthly>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Monthly> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Usage/Records/Monthly.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Monthly> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Monthly read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("usage_records", response.getContent(), Monthly.class, client.getObjectMapper());
    }

    @Override
    public Page<Monthly> previousPage(Page<Monthly> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Monthly> nextPage(Page<Monthly> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Monthly> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.category != null) {
            request.addQueryParam("Category", this.category.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", DateConverter.dateStringFromLocalDate(this.startDate));
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", DateConverter.dateStringFromLocalDate(this.endDate));
        }
        if (this.includeSubaccounts != null) {
            request.addQueryParam("IncludeSubaccounts", this.includeSubaccounts.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

