/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.usage.record;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.usage.record.LastMonth;
import java.time.LocalDate;

public class LastMonthReader
extends Reader<LastMonth> {
    private String pathAccountSid;
    private LastMonth.Category category;
    private LocalDate startDate;
    private LocalDate endDate;
    private Boolean includeSubaccounts;
    private Integer pageSize;

    public LastMonthReader() {
    }

    public LastMonthReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public LastMonthReader setCategory(LastMonth.Category category) {
        this.category = category;
        return this;
    }

    public LastMonthReader setStartDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    public LastMonthReader setEndDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    public LastMonthReader setIncludeSubaccounts(Boolean includeSubaccounts) {
        this.includeSubaccounts = includeSubaccounts;
        return this;
    }

    public LastMonthReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<LastMonth> read(TwilioRestClient client) {
        return new ResourceSet<LastMonth>(this, client, this.firstPage(client));
    }

    @Override
    public Page<LastMonth> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Usage/Records/LastMonth.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<LastMonth> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("LastMonth read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("usage_records", response.getContent(), LastMonth.class, client.getObjectMapper());
    }

    @Override
    public Page<LastMonth> previousPage(Page<LastMonth> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<LastMonth> nextPage(Page<LastMonth> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<LastMonth> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.category != null) {
            request.addQueryParam("Category", this.category.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", DateConverter.dateStringFromLocalDate(this.startDate));
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", DateConverter.dateStringFromLocalDate(this.endDate));
        }
        if (this.includeSubaccounts != null) {
            request.addQueryParam("IncludeSubaccounts", this.includeSubaccounts.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

