/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.usage.record;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.usage.record.Daily;
import java.time.LocalDate;

public class DailyReader
extends Reader<Daily> {
    private String pathAccountSid;
    private Daily.Category category;
    private LocalDate startDate;
    private LocalDate endDate;
    private Boolean includeSubaccounts;
    private Integer pageSize;

    public DailyReader() {
    }

    public DailyReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public DailyReader setCategory(Daily.Category category) {
        this.category = category;
        return this;
    }

    public DailyReader setStartDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    public DailyReader setEndDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    public DailyReader setIncludeSubaccounts(Boolean includeSubaccounts) {
        this.includeSubaccounts = includeSubaccounts;
        return this;
    }

    public DailyReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Daily> read(TwilioRestClient client) {
        return new ResourceSet<Daily>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Daily> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Usage/Records/Daily.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Daily> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Daily read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("usage_records", response.getContent(), Daily.class, client.getObjectMapper());
    }

    @Override
    public Page<Daily> previousPage(Page<Daily> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Daily> nextPage(Page<Daily> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Daily> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.category != null) {
            request.addQueryParam("Category", this.category.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", DateConverter.dateStringFromLocalDate(this.startDate));
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", DateConverter.dateStringFromLocalDate(this.endDate));
        }
        if (this.includeSubaccounts != null) {
            request.addQueryParam("IncludeSubaccounts", this.includeSubaccounts.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

