/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.domain;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.sip.domain.CredentialListMapping;

public class CredentialListMappingReader
extends Reader<CredentialListMapping> {
    private String pathDomainSid;
    private String pathAccountSid;
    private Integer pageSize;

    public CredentialListMappingReader(String pathDomainSid) {
        this.pathDomainSid = pathDomainSid;
    }

    public CredentialListMappingReader(String pathAccountSid, String pathDomainSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathDomainSid = pathDomainSid;
    }

    public CredentialListMappingReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<CredentialListMapping> read(TwilioRestClient client) {
        return new ResourceSet<CredentialListMapping>(this, client, this.firstPage(client));
    }

    @Override
    public Page<CredentialListMapping> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/CredentialListMappings.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{DomainSid}", this.pathDomainSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<CredentialListMapping> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CredentialListMapping read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("credential_list_mappings", response.getContent(), CredentialListMapping.class, client.getObjectMapper());
    }

    @Override
    public Page<CredentialListMapping> previousPage(Page<CredentialListMapping> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CredentialListMapping> nextPage(Page<CredentialListMapping> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CredentialListMapping> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

