/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip.domain;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.sip.domain.CredentialListMapping;

public class CredentialListMappingCreator
extends Creator<CredentialListMapping> {
    private String pathDomainSid;
    private String credentialListSid;
    private String pathAccountSid;

    public CredentialListMappingCreator(String pathDomainSid, String credentialListSid) {
        this.pathDomainSid = pathDomainSid;
        this.credentialListSid = credentialListSid;
    }

    public CredentialListMappingCreator(String pathAccountSid, String pathDomainSid, String credentialListSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathDomainSid = pathDomainSid;
        this.credentialListSid = credentialListSid;
    }

    public CredentialListMappingCreator setCredentialListSid(String credentialListSid) {
        this.credentialListSid = credentialListSid;
        return this;
    }

    @Override
    public CredentialListMapping create(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/SIP/Domains/{DomainSid}/CredentialListMappings.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{DomainSid}", this.pathDomainSid.toString());
        path = path.replace("{CredentialListSid}", this.credentialListSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CredentialListMapping creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return CredentialListMapping.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.credentialListSid != null) {
            request.addPostParam("CredentialListSid", this.credentialListSid);
        }
    }
}

