/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.sip;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.sip.CredentialListCreator;
import com.twilio.rest.api.v2010.account.sip.CredentialListDeleter;
import com.twilio.rest.api.v2010.account.sip.CredentialListFetcher;
import com.twilio.rest.api.v2010.account.sip.CredentialListReader;
import com.twilio.rest.api.v2010.account.sip.CredentialListUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CredentialList
extends Resource {
    private static final long serialVersionUID = 178395545365846L;
    private final String accountSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String friendlyName;
    private final String sid;
    private final Map<String, String> subresourceUris;
    private final String uri;

    public static CredentialListCreator creator(String friendlyName) {
        return new CredentialListCreator(friendlyName);
    }

    public static CredentialListCreator creator(String pathAccountSid, String friendlyName) {
        return new CredentialListCreator(pathAccountSid, friendlyName);
    }

    public static CredentialListDeleter deleter(String pathSid) {
        return new CredentialListDeleter(pathSid);
    }

    public static CredentialListDeleter deleter(String pathAccountSid, String pathSid) {
        return new CredentialListDeleter(pathAccountSid, pathSid);
    }

    public static CredentialListFetcher fetcher(String pathSid) {
        return new CredentialListFetcher(pathSid);
    }

    public static CredentialListFetcher fetcher(String pathAccountSid, String pathSid) {
        return new CredentialListFetcher(pathAccountSid, pathSid);
    }

    public static CredentialListReader reader() {
        return new CredentialListReader();
    }

    public static CredentialListReader reader(String pathAccountSid) {
        return new CredentialListReader(pathAccountSid);
    }

    public static CredentialListUpdater updater(String pathSid, String friendlyName) {
        return new CredentialListUpdater(pathSid, friendlyName);
    }

    public static CredentialListUpdater updater(String pathAccountSid, String pathSid, String friendlyName) {
        return new CredentialListUpdater(pathAccountSid, pathSid, friendlyName);
    }

    public static CredentialList fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CredentialList.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static CredentialList fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CredentialList.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private CredentialList(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.subresourceUris = subresourceUris;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialList other = (CredentialList)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.subresourceUris, other.subresourceUris) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.friendlyName, this.sid, this.subresourceUris, this.uri);
    }

    public String toString() {
        return "CredentialList(accountSid=" + this.getAccountSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", friendlyName=" + this.getFriendlyName() + ", sid=" + this.getSid() + ", subresourceUris=" + this.getSubresourceUris() + ", uri=" + this.getUri() + ")";
    }
}

