/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.recording;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.twilio.base.Resource;
import com.twilio.converter.CurrencyDeserializer;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.recording.TranscriptionDeleter;
import com.twilio.rest.api.v2010.account.recording.TranscriptionFetcher;
import com.twilio.rest.api.v2010.account.recording.TranscriptionReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Currency;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Transcription
extends Resource {
    private static final long serialVersionUID = 169453036448500L;
    private final String accountSid;
    private final String apiVersion;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String duration;
    private final BigDecimal price;
    private final Currency priceUnit;
    private final String recordingSid;
    private final String sid;
    private final Status status;
    private final String transcriptionText;
    private final String type;
    private final String uri;

    public static TranscriptionDeleter deleter(String pathRecordingSid, String pathSid) {
        return new TranscriptionDeleter(pathRecordingSid, pathSid);
    }

    public static TranscriptionDeleter deleter(String pathAccountSid, String pathRecordingSid, String pathSid) {
        return new TranscriptionDeleter(pathAccountSid, pathRecordingSid, pathSid);
    }

    public static TranscriptionFetcher fetcher(String pathRecordingSid, String pathSid) {
        return new TranscriptionFetcher(pathRecordingSid, pathSid);
    }

    public static TranscriptionFetcher fetcher(String pathAccountSid, String pathRecordingSid, String pathSid) {
        return new TranscriptionFetcher(pathAccountSid, pathRecordingSid, pathSid);
    }

    public static TranscriptionReader reader(String pathRecordingSid) {
        return new TranscriptionReader(pathRecordingSid);
    }

    public static TranscriptionReader reader(String pathAccountSid, String pathRecordingSid) {
        return new TranscriptionReader(pathAccountSid, pathRecordingSid);
    }

    public static Transcription fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Transcription.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Transcription fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Transcription.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Transcription(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="duration") String duration, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="recording_sid") String recordingSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="status") Status status, @JsonProperty(value="transcription_text") String transcriptionText, @JsonProperty(value="type") String type, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.duration = duration;
        this.price = price;
        this.priceUnit = priceUnit;
        this.recordingSid = recordingSid;
        this.sid = sid;
        this.status = status;
        this.transcriptionText = transcriptionText;
        this.type = type;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDuration() {
        return this.duration;
    }

    public final BigDecimal getPrice() {
        return this.price;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    public final String getRecordingSid() {
        return this.recordingSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getTranscriptionText() {
        return this.transcriptionText;
    }

    public final String getType() {
        return this.type;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transcription other = (Transcription)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.duration, other.duration) && Objects.equals(this.price, other.price) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals(this.recordingSid, other.recordingSid) && Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.transcriptionText, other.transcriptionText) && Objects.equals(this.type, other.type) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.apiVersion, this.dateCreated, this.dateUpdated, this.duration, this.price, this.priceUnit, this.recordingSid, this.sid, this.status, this.transcriptionText, this.type, this.uri});
    }

    public String toString() {
        return "Transcription(accountSid=" + this.getAccountSid() + ", apiVersion=" + this.getApiVersion() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", duration=" + this.getDuration() + ", price=" + this.getPrice() + ", priceUnit=" + this.getPriceUnit() + ", recordingSid=" + this.getRecordingSid() + ", sid=" + this.getSid() + ", status=" + (Object)((Object)this.getStatus()) + ", transcriptionText=" + this.getTranscriptionText() + ", type=" + this.getType() + ", uri=" + this.getUri() + ")";
    }

    public static enum Status {
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

