/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.recording;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.recording.AddOnResultDeleter;
import com.twilio.rest.api.v2010.account.recording.AddOnResultFetcher;
import com.twilio.rest.api.v2010.account.recording.AddOnResultReader;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AddOnResult
extends Resource {
    private static final long serialVersionUID = 121199532836736L;
    private final String sid;
    private final String accountSid;
    private final Status status;
    private final String addOnSid;
    private final String addOnConfigurationSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final ZonedDateTime dateCompleted;
    private final String referenceSid;
    private final Map<String, String> subresourceUris;

    public static AddOnResultDeleter deleter(String pathReferenceSid, String pathSid) {
        return new AddOnResultDeleter(pathReferenceSid, pathSid);
    }

    public static AddOnResultDeleter deleter(String pathAccountSid, String pathReferenceSid, String pathSid) {
        return new AddOnResultDeleter(pathAccountSid, pathReferenceSid, pathSid);
    }

    public static AddOnResultFetcher fetcher(String pathReferenceSid, String pathSid) {
        return new AddOnResultFetcher(pathReferenceSid, pathSid);
    }

    public static AddOnResultFetcher fetcher(String pathAccountSid, String pathReferenceSid, String pathSid) {
        return new AddOnResultFetcher(pathAccountSid, pathReferenceSid, pathSid);
    }

    public static AddOnResultReader reader(String pathReferenceSid) {
        return new AddOnResultReader(pathReferenceSid);
    }

    public static AddOnResultReader reader(String pathAccountSid, String pathReferenceSid) {
        return new AddOnResultReader(pathAccountSid, pathReferenceSid);
    }

    public static AddOnResult fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AddOnResult.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AddOnResult fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AddOnResult.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AddOnResult(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="status") Status status, @JsonProperty(value="add_on_sid") String addOnSid, @JsonProperty(value="add_on_configuration_sid") String addOnConfigurationSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="date_completed") String dateCompleted, @JsonProperty(value="reference_sid") String referenceSid, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.status = status;
        this.addOnSid = addOnSid;
        this.addOnConfigurationSid = addOnConfigurationSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.dateCompleted = DateConverter.rfc2822DateTimeFromString(dateCompleted);
        this.referenceSid = referenceSid;
        this.subresourceUris = subresourceUris;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getAddOnSid() {
        return this.addOnSid;
    }

    public final String getAddOnConfigurationSid() {
        return this.addOnConfigurationSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final ZonedDateTime getDateCompleted() {
        return this.dateCompleted;
    }

    public final String getReferenceSid() {
        return this.referenceSid;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddOnResult other = (AddOnResult)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.addOnSid, other.addOnSid) && Objects.equals(this.addOnConfigurationSid, other.addOnConfigurationSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.dateCompleted, other.dateCompleted) && Objects.equals(this.referenceSid, other.referenceSid) && Objects.equals(this.subresourceUris, other.subresourceUris);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.status, this.addOnSid, this.addOnConfigurationSid, this.dateCreated, this.dateUpdated, this.dateCompleted, this.referenceSid, this.subresourceUris});
    }

    public String toString() {
        return "AddOnResult(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", status=" + (Object)((Object)this.getStatus()) + ", addOnSid=" + this.getAddOnSid() + ", addOnConfigurationSid=" + this.getAddOnConfigurationSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", dateCompleted=" + this.getDateCompleted() + ", referenceSid=" + this.getReferenceSid() + ", subresourceUris=" + this.getSubresourceUris() + ")";
    }

    public static enum Status {
        CANCELED("canceled"),
        COMPLETED("completed"),
        DELETED("deleted"),
        FAILED("failed"),
        IN_PROGRESS("in-progress"),
        INIT("init"),
        PROCESSING("processing"),
        QUEUED("queued");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

