/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.incomingphonenumber;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.incomingphonenumber.AssignedAddOn;

public class AssignedAddOnCreator
extends Creator<AssignedAddOn> {
    private String pathResourceSid;
    private String installedAddOnSid;
    private String pathAccountSid;

    public AssignedAddOnCreator(String pathResourceSid, String installedAddOnSid) {
        this.pathResourceSid = pathResourceSid;
        this.installedAddOnSid = installedAddOnSid;
    }

    public AssignedAddOnCreator(String pathAccountSid, String pathResourceSid, String installedAddOnSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathResourceSid = pathResourceSid;
        this.installedAddOnSid = installedAddOnSid;
    }

    public AssignedAddOnCreator setInstalledAddOnSid(String installedAddOnSid) {
        this.installedAddOnSid = installedAddOnSid;
        return this;
    }

    @Override
    public AssignedAddOn create(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/IncomingPhoneNumbers/{ResourceSid}/AssignedAddOns.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{ResourceSid}", this.pathResourceSid.toString());
        path = path.replace("{InstalledAddOnSid}", this.installedAddOnSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AssignedAddOn creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AssignedAddOn.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.installedAddOnSid != null) {
            request.addPostParam("InstalledAddOnSid", this.installedAddOnSid);
        }
    }
}

