/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.incomingphonenumber;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.incomingphonenumber.AssignedAddOnCreator;
import com.twilio.rest.api.v2010.account.incomingphonenumber.AssignedAddOnDeleter;
import com.twilio.rest.api.v2010.account.incomingphonenumber.AssignedAddOnFetcher;
import com.twilio.rest.api.v2010.account.incomingphonenumber.AssignedAddOnReader;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AssignedAddOn
extends Resource {
    private static final long serialVersionUID = 114193682949091L;
    private final String sid;
    private final String accountSid;
    private final String resourceSid;
    private final String friendlyName;
    private final String description;
    private final Map<String, Object> configuration;
    private final String uniqueName;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String uri;
    private final Map<String, String> subresourceUris;

    public static AssignedAddOnCreator creator(String pathResourceSid, String installedAddOnSid) {
        return new AssignedAddOnCreator(pathResourceSid, installedAddOnSid);
    }

    public static AssignedAddOnCreator creator(String pathAccountSid, String pathResourceSid, String installedAddOnSid) {
        return new AssignedAddOnCreator(pathAccountSid, pathResourceSid, installedAddOnSid);
    }

    public static AssignedAddOnDeleter deleter(String pathResourceSid, String pathSid) {
        return new AssignedAddOnDeleter(pathResourceSid, pathSid);
    }

    public static AssignedAddOnDeleter deleter(String pathAccountSid, String pathResourceSid, String pathSid) {
        return new AssignedAddOnDeleter(pathAccountSid, pathResourceSid, pathSid);
    }

    public static AssignedAddOnFetcher fetcher(String pathResourceSid, String pathSid) {
        return new AssignedAddOnFetcher(pathResourceSid, pathSid);
    }

    public static AssignedAddOnFetcher fetcher(String pathAccountSid, String pathResourceSid, String pathSid) {
        return new AssignedAddOnFetcher(pathAccountSid, pathResourceSid, pathSid);
    }

    public static AssignedAddOnReader reader(String pathResourceSid) {
        return new AssignedAddOnReader(pathResourceSid);
    }

    public static AssignedAddOnReader reader(String pathAccountSid, String pathResourceSid) {
        return new AssignedAddOnReader(pathAccountSid, pathResourceSid);
    }

    public static AssignedAddOn fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AssignedAddOn.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AssignedAddOn fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AssignedAddOn.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AssignedAddOn(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="resource_sid") String resourceSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="description") String description, @JsonProperty(value="configuration") Map<String, Object> configuration, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="uri") String uri, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.resourceSid = resourceSid;
        this.friendlyName = friendlyName;
        this.description = description;
        this.configuration = configuration;
        this.uniqueName = uniqueName;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.uri = uri;
        this.subresourceUris = subresourceUris;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getResourceSid() {
        return this.resourceSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getUri() {
        return this.uri;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignedAddOn other = (AssignedAddOn)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.resourceSid, other.resourceSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.description, other.description) && Objects.equals(this.configuration, other.configuration) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.uri, other.uri) && Objects.equals(this.subresourceUris, other.subresourceUris);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.resourceSid, this.friendlyName, this.description, this.configuration, this.uniqueName, this.dateCreated, this.dateUpdated, this.uri, this.subresourceUris);
    }

    public String toString() {
        return "AssignedAddOn(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", resourceSid=" + this.getResourceSid() + ", friendlyName=" + this.getFriendlyName() + ", description=" + this.getDescription() + ", configuration=" + this.getConfiguration() + ", uniqueName=" + this.getUniqueName() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", uri=" + this.getUri() + ", subresourceUris=" + this.getSubresourceUris() + ")";
    }
}

