/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.conference;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.conference.Recording;

public class RecordingFetcher
extends Fetcher<Recording> {
    private String pathConferenceSid;
    private String pathSid;
    private String pathAccountSid;

    public RecordingFetcher(String pathConferenceSid, String pathSid) {
        this.pathConferenceSid = pathConferenceSid;
        this.pathSid = pathSid;
    }

    public RecordingFetcher(String pathAccountSid, String pathConferenceSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathConferenceSid = pathConferenceSid;
        this.pathSid = pathSid;
    }

    @Override
    public Recording fetch(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Conferences/{ConferenceSid}/Recordings/{Sid}.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{ConferenceSid}", this.pathConferenceSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Recording fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Recording.fromJson(response.getStream(), client.getObjectMapper());
    }
}

