/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.conference;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.conference.ParticipantCreator;
import com.twilio.rest.api.v2010.account.conference.ParticipantDeleter;
import com.twilio.rest.api.v2010.account.conference.ParticipantFetcher;
import com.twilio.rest.api.v2010.account.conference.ParticipantReader;
import com.twilio.rest.api.v2010.account.conference.ParticipantUpdater;
import com.twilio.type.Endpoint;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Participant
extends Resource {
    private static final long serialVersionUID = 178960491032323L;
    private final String accountSid;
    private final String callSid;
    private final String label;
    private final String callSidToCoach;
    private final Boolean coaching;
    private final String conferenceSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final Boolean endConferenceOnExit;
    private final Boolean muted;
    private final Boolean hold;
    private final Boolean startConferenceOnEnter;
    private final Status status;
    private final String queueTime;
    private final String uri;

    public static ParticipantCreator creator(String pathConferenceSid, Endpoint from, Endpoint to) {
        return new ParticipantCreator(pathConferenceSid, from, to);
    }

    public static ParticipantCreator creator(String pathAccountSid, String pathConferenceSid, Endpoint from, Endpoint to) {
        return new ParticipantCreator(pathAccountSid, pathConferenceSid, from, to);
    }

    public static ParticipantDeleter deleter(String pathConferenceSid, String pathCallSid) {
        return new ParticipantDeleter(pathConferenceSid, pathCallSid);
    }

    public static ParticipantDeleter deleter(String pathAccountSid, String pathConferenceSid, String pathCallSid) {
        return new ParticipantDeleter(pathAccountSid, pathConferenceSid, pathCallSid);
    }

    public static ParticipantFetcher fetcher(String pathConferenceSid, String pathCallSid) {
        return new ParticipantFetcher(pathConferenceSid, pathCallSid);
    }

    public static ParticipantFetcher fetcher(String pathAccountSid, String pathConferenceSid, String pathCallSid) {
        return new ParticipantFetcher(pathAccountSid, pathConferenceSid, pathCallSid);
    }

    public static ParticipantReader reader(String pathConferenceSid) {
        return new ParticipantReader(pathConferenceSid);
    }

    public static ParticipantReader reader(String pathAccountSid, String pathConferenceSid) {
        return new ParticipantReader(pathAccountSid, pathConferenceSid);
    }

    public static ParticipantUpdater updater(String pathConferenceSid, String pathCallSid) {
        return new ParticipantUpdater(pathConferenceSid, pathCallSid);
    }

    public static ParticipantUpdater updater(String pathAccountSid, String pathConferenceSid, String pathCallSid) {
        return new ParticipantUpdater(pathAccountSid, pathConferenceSid, pathCallSid);
    }

    public static Participant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Participant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Participant(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="label") String label, @JsonProperty(value="call_sid_to_coach") String callSidToCoach, @JsonProperty(value="coaching") Boolean coaching, @JsonProperty(value="conference_sid") String conferenceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="end_conference_on_exit") Boolean endConferenceOnExit, @JsonProperty(value="muted") Boolean muted, @JsonProperty(value="hold") Boolean hold, @JsonProperty(value="start_conference_on_enter") Boolean startConferenceOnEnter, @JsonProperty(value="status") Status status, @JsonProperty(value="queue_time") String queueTime, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.label = label;
        this.callSidToCoach = callSidToCoach;
        this.coaching = coaching;
        this.conferenceSid = conferenceSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.endConferenceOnExit = endConferenceOnExit;
        this.muted = muted;
        this.hold = hold;
        this.startConferenceOnEnter = startConferenceOnEnter;
        this.status = status;
        this.queueTime = queueTime;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getCallSidToCoach() {
        return this.callSidToCoach;
    }

    public final Boolean getCoaching() {
        return this.coaching;
    }

    public final String getConferenceSid() {
        return this.conferenceSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Boolean getEndConferenceOnExit() {
        return this.endConferenceOnExit;
    }

    public final Boolean getMuted() {
        return this.muted;
    }

    public final Boolean getHold() {
        return this.hold;
    }

    public final Boolean getStartConferenceOnEnter() {
        return this.startConferenceOnEnter;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getQueueTime() {
        return this.queueTime;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Participant other = (Participant)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.label, other.label) && Objects.equals(this.callSidToCoach, other.callSidToCoach) && Objects.equals(this.coaching, other.coaching) && Objects.equals(this.conferenceSid, other.conferenceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.endConferenceOnExit, other.endConferenceOnExit) && Objects.equals(this.muted, other.muted) && Objects.equals(this.hold, other.hold) && Objects.equals(this.startConferenceOnEnter, other.startConferenceOnEnter) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.queueTime, other.queueTime) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.callSid, this.label, this.callSidToCoach, this.coaching, this.conferenceSid, this.dateCreated, this.dateUpdated, this.endConferenceOnExit, this.muted, this.hold, this.startConferenceOnEnter, this.status, this.queueTime, this.uri});
    }

    public String toString() {
        return "Participant(accountSid=" + this.getAccountSid() + ", callSid=" + this.getCallSid() + ", label=" + this.getLabel() + ", callSidToCoach=" + this.getCallSidToCoach() + ", coaching=" + this.getCoaching() + ", conferenceSid=" + this.getConferenceSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", endConferenceOnExit=" + this.getEndConferenceOnExit() + ", muted=" + this.getMuted() + ", hold=" + this.getHold() + ", startConferenceOnEnter=" + this.getStartConferenceOnEnter() + ", status=" + (Object)((Object)this.getStatus()) + ", queueTime=" + this.getQueueTime() + ", uri=" + this.getUri() + ")";
    }

    public static enum Status {
        QUEUED("queued"),
        CONNECTING("connecting"),
        RINGING("ringing"),
        CONNECTED("connected"),
        COMPLETE("complete"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

