/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.twilio.base.Resource;
import com.twilio.converter.CurrencyDeserializer;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.call.RecordingCreator;
import com.twilio.rest.api.v2010.account.call.RecordingDeleter;
import com.twilio.rest.api.v2010.account.call.RecordingFetcher;
import com.twilio.rest.api.v2010.account.call.RecordingReader;
import com.twilio.rest.api.v2010.account.call.RecordingUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Currency;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Recording
extends Resource {
    private static final long serialVersionUID = 269042081197241L;
    private final String accountSid;
    private final String apiVersion;
    private final String callSid;
    private final String conferenceSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final ZonedDateTime startTime;
    private final String duration;
    private final String sid;
    private final BigDecimal price;
    private final String uri;
    private final Map<String, Object> encryptionDetails;
    private final Currency priceUnit;
    private final Status status;
    private final Integer channels;
    private final Source source;
    private final Integer errorCode;
    private final String track;

    public static RecordingCreator creator(String pathCallSid) {
        return new RecordingCreator(pathCallSid);
    }

    public static RecordingCreator creator(String pathAccountSid, String pathCallSid) {
        return new RecordingCreator(pathAccountSid, pathCallSid);
    }

    public static RecordingDeleter deleter(String pathCallSid, String pathSid) {
        return new RecordingDeleter(pathCallSid, pathSid);
    }

    public static RecordingDeleter deleter(String pathAccountSid, String pathCallSid, String pathSid) {
        return new RecordingDeleter(pathAccountSid, pathCallSid, pathSid);
    }

    public static RecordingFetcher fetcher(String pathCallSid, String pathSid) {
        return new RecordingFetcher(pathCallSid, pathSid);
    }

    public static RecordingFetcher fetcher(String pathAccountSid, String pathCallSid, String pathSid) {
        return new RecordingFetcher(pathAccountSid, pathCallSid, pathSid);
    }

    public static RecordingReader reader(String pathCallSid) {
        return new RecordingReader(pathCallSid);
    }

    public static RecordingReader reader(String pathAccountSid, String pathCallSid) {
        return new RecordingReader(pathAccountSid, pathCallSid);
    }

    public static RecordingUpdater updater(String pathCallSid, String pathSid, Status status) {
        return new RecordingUpdater(pathCallSid, pathSid, status);
    }

    public static RecordingUpdater updater(String pathAccountSid, String pathCallSid, String pathSid, Status status) {
        return new RecordingUpdater(pathAccountSid, pathCallSid, pathSid, status);
    }

    public static Recording fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Recording.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Recording fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Recording.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Recording(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="conference_sid") String conferenceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="start_time") String startTime, @JsonProperty(value="duration") String duration, @JsonProperty(value="sid") String sid, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="uri") String uri, @JsonProperty(value="encryption_details") Map<String, Object> encryptionDetails, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="status") Status status, @JsonProperty(value="channels") Integer channels, @JsonProperty(value="source") Source source, @JsonProperty(value="error_code") Integer errorCode, @JsonProperty(value="track") String track) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.callSid = callSid;
        this.conferenceSid = conferenceSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.startTime = DateConverter.rfc2822DateTimeFromString(startTime);
        this.duration = duration;
        this.sid = sid;
        this.price = price;
        this.uri = uri;
        this.encryptionDetails = encryptionDetails;
        this.priceUnit = priceUnit;
        this.status = status;
        this.channels = channels;
        this.source = source;
        this.errorCode = errorCode;
        this.track = track;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getConferenceSid() {
        return this.conferenceSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public final String getDuration() {
        return this.duration;
    }

    public final String getSid() {
        return this.sid;
    }

    public final BigDecimal getPrice() {
        return this.price;
    }

    public final String getUri() {
        return this.uri;
    }

    public final Map<String, Object> getEncryptionDetails() {
        return this.encryptionDetails;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Integer getChannels() {
        return this.channels;
    }

    public final Source getSource() {
        return this.source;
    }

    public final Integer getErrorCode() {
        return this.errorCode;
    }

    public final String getTrack() {
        return this.track;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recording other = (Recording)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.conferenceSid, other.conferenceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.duration, other.duration) && Objects.equals(this.sid, other.sid) && Objects.equals(this.price, other.price) && Objects.equals(this.uri, other.uri) && Objects.equals(this.encryptionDetails, other.encryptionDetails) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.channels, other.channels) && Objects.equals((Object)this.source, (Object)other.source) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.track, other.track);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.apiVersion, this.callSid, this.conferenceSid, this.dateCreated, this.dateUpdated, this.startTime, this.duration, this.sid, this.price, this.uri, this.encryptionDetails, this.priceUnit, this.status, this.channels, this.source, this.errorCode, this.track});
    }

    public String toString() {
        return "Recording(accountSid=" + this.getAccountSid() + ", apiVersion=" + this.getApiVersion() + ", callSid=" + this.getCallSid() + ", conferenceSid=" + this.getConferenceSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", startTime=" + this.getStartTime() + ", duration=" + this.getDuration() + ", sid=" + this.getSid() + ", price=" + this.getPrice() + ", uri=" + this.getUri() + ", encryptionDetails=" + this.getEncryptionDetails() + ", priceUnit=" + this.getPriceUnit() + ", status=" + (Object)((Object)this.getStatus()) + ", channels=" + this.getChannels() + ", source=" + (Object)((Object)this.getSource()) + ", errorCode=" + this.getErrorCode() + ", track=" + this.getTrack() + ")";
    }

    public static enum Status {
        IN_PROGRESS("in-progress"),
        PAUSED("paused"),
        STOPPED("stopped"),
        PROCESSING("processing"),
        COMPLETED("completed"),
        ABSENT("absent");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum Source {
        DIALVERB("DialVerb"),
        CONFERENCE("Conference"),
        OUTBOUNDAPI("OutboundAPI"),
        TRUNKING("Trunking"),
        RECORDVERB("RecordVerb"),
        STARTCALLRECORDINGAPI("StartCallRecordingAPI"),
        STARTCONFERENCERECORDINGAPI("StartConferenceRecordingAPI");

        private final String value;

        private Source(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Source forValue(String value) {
            return (Source)Promoter.enumFromString((String)value, (Enum[])Source.values());
        }
    }
}

