/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.call.Payment;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Map;

public class PaymentCreator
extends Creator<Payment> {
    private String pathCallSid;
    private String idempotencyKey;
    private URI statusCallback;
    private String pathAccountSid;
    private Payment.BankAccountType bankAccountType;
    private BigDecimal chargeAmount;
    private String currency;
    private String description;
    private String input;
    private Integer minPostalCodeLength;
    private Map<String, Object> parameter;
    private String paymentConnector;
    private Payment.PaymentMethod paymentMethod;
    private Boolean postalCode;
    private Boolean securityCode;
    private Integer timeout;
    private Payment.TokenType tokenType;
    private String validCardTypes;

    public PaymentCreator(String pathCallSid, String idempotencyKey, URI statusCallback) {
        this.pathCallSid = pathCallSid;
        this.idempotencyKey = idempotencyKey;
        this.statusCallback = statusCallback;
    }

    public PaymentCreator(String pathAccountSid, String pathCallSid, String idempotencyKey, URI statusCallback) {
        this.pathAccountSid = pathAccountSid;
        this.pathCallSid = pathCallSid;
        this.idempotencyKey = idempotencyKey;
        this.statusCallback = statusCallback;
    }

    public PaymentCreator setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    public PaymentCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public PaymentCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public PaymentCreator setBankAccountType(Payment.BankAccountType bankAccountType) {
        this.bankAccountType = bankAccountType;
        return this;
    }

    public PaymentCreator setChargeAmount(BigDecimal chargeAmount) {
        this.chargeAmount = chargeAmount;
        return this;
    }

    public PaymentCreator setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public PaymentCreator setDescription(String description) {
        this.description = description;
        return this;
    }

    public PaymentCreator setInput(String input) {
        this.input = input;
        return this;
    }

    public PaymentCreator setMinPostalCodeLength(Integer minPostalCodeLength) {
        this.minPostalCodeLength = minPostalCodeLength;
        return this;
    }

    public PaymentCreator setParameter(Map<String, Object> parameter) {
        this.parameter = parameter;
        return this;
    }

    public PaymentCreator setPaymentConnector(String paymentConnector) {
        this.paymentConnector = paymentConnector;
        return this;
    }

    public PaymentCreator setPaymentMethod(Payment.PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    public PaymentCreator setPostalCode(Boolean postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public PaymentCreator setSecurityCode(Boolean securityCode) {
        this.securityCode = securityCode;
        return this;
    }

    public PaymentCreator setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public PaymentCreator setTokenType(Payment.TokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public PaymentCreator setValidCardTypes(String validCardTypes) {
        this.validCardTypes = validCardTypes;
        return this;
    }

    @Override
    public Payment create(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Calls/{CallSid}/Payments.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{CallSid}", this.pathCallSid.toString());
        path = path.replace("{IdempotencyKey}", this.idempotencyKey.toString());
        path = path.replace("{StatusCallback}", this.statusCallback.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Payment creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Payment.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.idempotencyKey != null) {
            request.addPostParam("IdempotencyKey", this.idempotencyKey);
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.bankAccountType != null) {
            request.addPostParam("BankAccountType", this.bankAccountType.toString());
        }
        if (this.chargeAmount != null) {
            request.addPostParam("ChargeAmount", this.chargeAmount.toString());
        }
        if (this.currency != null) {
            request.addPostParam("Currency", this.currency);
        }
        if (this.description != null) {
            request.addPostParam("Description", this.description);
        }
        if (this.input != null) {
            request.addPostParam("Input", this.input);
        }
        if (this.minPostalCodeLength != null) {
            request.addPostParam("MinPostalCodeLength", this.minPostalCodeLength.toString());
        }
        if (this.parameter != null) {
            request.addPostParam("Parameter", Converter.mapToJson(this.parameter));
        }
        if (this.paymentConnector != null) {
            request.addPostParam("PaymentConnector", this.paymentConnector);
        }
        if (this.paymentMethod != null) {
            request.addPostParam("PaymentMethod", this.paymentMethod.toString());
        }
        if (this.postalCode != null) {
            request.addPostParam("PostalCode", this.postalCode.toString());
        }
        if (this.securityCode != null) {
            request.addPostParam("SecurityCode", this.securityCode.toString());
        }
        if (this.timeout != null) {
            request.addPostParam("Timeout", this.timeout.toString());
        }
        if (this.tokenType != null) {
            request.addPostParam("TokenType", this.tokenType.toString());
        }
        if (this.validCardTypes != null) {
            request.addPostParam("ValidCardTypes", this.validCardTypes);
        }
    }
}

