/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.api.v2010.account.ShortCodeFetcher;
import com.twilio.rest.api.v2010.account.ShortCodeReader;
import com.twilio.rest.api.v2010.account.ShortCodeUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ShortCode
extends Resource {
    private static final long serialVersionUID = 169753160210519L;
    private final String accountSid;
    private final String apiVersion;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String friendlyName;
    private final String shortCode;
    private final String sid;
    private final HttpMethod smsFallbackMethod;
    private final URI smsFallbackUrl;
    private final HttpMethod smsMethod;
    private final URI smsUrl;
    private final String uri;

    public static ShortCodeFetcher fetcher(String pathSid) {
        return new ShortCodeFetcher(pathSid);
    }

    public static ShortCodeFetcher fetcher(String pathAccountSid, String pathSid) {
        return new ShortCodeFetcher(pathAccountSid, pathSid);
    }

    public static ShortCodeReader reader() {
        return new ShortCodeReader();
    }

    public static ShortCodeReader reader(String pathAccountSid) {
        return new ShortCodeReader(pathAccountSid);
    }

    public static ShortCodeUpdater updater(String pathSid) {
        return new ShortCodeUpdater(pathSid);
    }

    public static ShortCodeUpdater updater(String pathAccountSid, String pathSid) {
        return new ShortCodeUpdater(pathAccountSid, pathSid);
    }

    public static ShortCode fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ShortCode.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ShortCode fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ShortCode.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ShortCode(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="short_code") String shortCode, @JsonProperty(value="sid") String sid, @JsonProperty(value="sms_fallback_method") HttpMethod smsFallbackMethod, @JsonProperty(value="sms_fallback_url") URI smsFallbackUrl, @JsonProperty(value="sms_method") HttpMethod smsMethod, @JsonProperty(value="sms_url") URI smsUrl, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.shortCode = shortCode;
        this.sid = sid;
        this.smsFallbackMethod = smsFallbackMethod;
        this.smsFallbackUrl = smsFallbackUrl;
        this.smsMethod = smsMethod;
        this.smsUrl = smsUrl;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getShortCode() {
        return this.shortCode;
    }

    public final String getSid() {
        return this.sid;
    }

    public final HttpMethod getSmsFallbackMethod() {
        return this.smsFallbackMethod;
    }

    public final URI getSmsFallbackUrl() {
        return this.smsFallbackUrl;
    }

    public final HttpMethod getSmsMethod() {
        return this.smsMethod;
    }

    public final URI getSmsUrl() {
        return this.smsUrl;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortCode other = (ShortCode)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.shortCode, other.shortCode) && Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.smsFallbackMethod, (Object)other.smsFallbackMethod) && Objects.equals(this.smsFallbackUrl, other.smsFallbackUrl) && Objects.equals((Object)this.smsMethod, (Object)other.smsMethod) && Objects.equals(this.smsUrl, other.smsUrl) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.apiVersion, this.dateCreated, this.dateUpdated, this.friendlyName, this.shortCode, this.sid, this.smsFallbackMethod, this.smsFallbackUrl, this.smsMethod, this.smsUrl, this.uri});
    }

    public String toString() {
        return "ShortCode(accountSid=" + this.getAccountSid() + ", apiVersion=" + this.getApiVersion() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", friendlyName=" + this.getFriendlyName() + ", shortCode=" + this.getShortCode() + ", sid=" + this.getSid() + ", smsFallbackMethod=" + (Object)((Object)this.getSmsFallbackMethod()) + ", smsFallbackUrl=" + this.getSmsFallbackUrl() + ", smsMethod=" + (Object)((Object)this.getSmsMethod()) + ", smsUrl=" + this.getSmsUrl() + ", uri=" + this.getUri() + ")";
    }
}

