/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Message;

public class MessageUpdater
extends Updater<Message> {
    private String pathSid;
    private String pathAccountSid;
    private String body;
    private Message.UpdateStatus status;

    public MessageUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public MessageUpdater(String pathAccountSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathSid = pathSid;
    }

    public MessageUpdater setBody(String body) {
        this.body = body;
        return this;
    }

    public MessageUpdater setStatus(Message.UpdateStatus status) {
        this.status = status;
        return this;
    }

    @Override
    public Message update(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Messages/{Sid}.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Message update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Message.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.body != null) {
            request.addPostParam("Body", this.body);
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

