/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Call;
import com.twilio.type.PhoneNumber;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class CallReader
extends Reader<Call> {
    private String pathAccountSid;
    private PhoneNumber to;
    private PhoneNumber from;
    private String parentCallSid;
    private Call.Status status;
    private ZonedDateTime startTime;
    private ZonedDateTime startTimeBefore;
    private ZonedDateTime startTimeAfter;
    private ZonedDateTime endTime;
    private ZonedDateTime endTimeBefore;
    private ZonedDateTime endTimeAfter;
    private Integer pageSize;

    public CallReader() {
    }

    public CallReader(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public CallReader setTo(PhoneNumber to) {
        this.to = to;
        return this;
    }

    public CallReader setTo(String to) {
        return this.setTo(Promoter.phoneNumberFromString(to));
    }

    public CallReader setFrom(PhoneNumber from) {
        this.from = from;
        return this;
    }

    public CallReader setFrom(String from) {
        return this.setFrom(Promoter.phoneNumberFromString(from));
    }

    public CallReader setParentCallSid(String parentCallSid) {
        this.parentCallSid = parentCallSid;
        return this;
    }

    public CallReader setStatus(Call.Status status) {
        this.status = status;
        return this;
    }

    public CallReader setStartTime(ZonedDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public CallReader setStartTimeBefore(ZonedDateTime startTimeBefore) {
        this.startTimeBefore = startTimeBefore;
        return this;
    }

    public CallReader setStartTimeAfter(ZonedDateTime startTimeAfter) {
        this.startTimeAfter = startTimeAfter;
        return this;
    }

    public CallReader setEndTime(ZonedDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public CallReader setEndTimeBefore(ZonedDateTime endTimeBefore) {
        this.endTimeBefore = endTimeBefore;
        return this;
    }

    public CallReader setEndTimeAfter(ZonedDateTime endTimeAfter) {
        this.endTimeAfter = endTimeAfter;
        return this;
    }

    public CallReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Call> read(TwilioRestClient client) {
        return new ResourceSet<Call>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Call> firstPage(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Calls.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<Call> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Call read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("calls", response.getContent(), Call.class, client.getObjectMapper());
    }

    @Override
    public Page<Call> previousPage(Page<Call> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Call> nextPage(Page<Call> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Call> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.to != null) {
            request.addQueryParam("To", this.to.toString());
        }
        if (this.from != null) {
            request.addQueryParam("From", this.from.toString());
        }
        if (this.parentCallSid != null) {
            request.addQueryParam("ParentCallSid", this.parentCallSid);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.startTime != null) {
            request.addQueryParam("StartTime", this.startTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")));
        } else if (this.startTimeAfter != null || this.startTimeBefore != null) {
            request.addQueryDateTimeRange("StartTime", this.startTimeAfter, this.startTimeBefore);
        }
        if (this.endTime != null) {
            request.addQueryParam("EndTime", this.endTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")));
        } else if (this.endTimeAfter != null || this.endTimeBefore != null) {
            request.addQueryDateTimeRange("EndTime", this.endTimeAfter, this.endTimeBefore);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

