/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.AuthorizedConnectApp;

public class AuthorizedConnectAppFetcher
extends Fetcher<AuthorizedConnectApp> {
    private String pathConnectAppSid;
    private String pathAccountSid;

    public AuthorizedConnectAppFetcher(String pathConnectAppSid) {
        this.pathConnectAppSid = pathConnectAppSid;
    }

    public AuthorizedConnectAppFetcher(String pathAccountSid, String pathConnectAppSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathConnectAppSid = pathConnectAppSid;
    }

    @Override
    public AuthorizedConnectApp fetch(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/AuthorizedConnectApps/{ConnectAppSid}.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{ConnectAppSid}", this.pathConnectAppSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AuthorizedConnectApp fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AuthorizedConnectApp.fromJson(response.getStream(), client.getObjectMapper());
    }
}

