/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Address;

public class AddressCreator
extends Creator<Address> {
    private String customerName;
    private String street;
    private String city;
    private String region;
    private String postalCode;
    private String isoCountry;
    private String pathAccountSid;
    private String friendlyName;
    private Boolean emergencyEnabled;
    private Boolean autoCorrectAddress;
    private String streetSecondary;

    public AddressCreator(String customerName, String street, String city, String region, String postalCode, String isoCountry) {
        this.customerName = customerName;
        this.street = street;
        this.city = city;
        this.region = region;
        this.postalCode = postalCode;
        this.isoCountry = isoCountry;
    }

    public AddressCreator(String pathAccountSid, String customerName, String street, String city, String region, String postalCode, String isoCountry) {
        this.pathAccountSid = pathAccountSid;
        this.customerName = customerName;
        this.street = street;
        this.city = city;
        this.region = region;
        this.postalCode = postalCode;
        this.isoCountry = isoCountry;
    }

    public AddressCreator setCustomerName(String customerName) {
        this.customerName = customerName;
        return this;
    }

    public AddressCreator setStreet(String street) {
        this.street = street;
        return this;
    }

    public AddressCreator setCity(String city) {
        this.city = city;
        return this;
    }

    public AddressCreator setRegion(String region) {
        this.region = region;
        return this;
    }

    public AddressCreator setPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public AddressCreator setIsoCountry(String isoCountry) {
        this.isoCountry = isoCountry;
        return this;
    }

    public AddressCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AddressCreator setEmergencyEnabled(Boolean emergencyEnabled) {
        this.emergencyEnabled = emergencyEnabled;
        return this;
    }

    public AddressCreator setAutoCorrectAddress(Boolean autoCorrectAddress) {
        this.autoCorrectAddress = autoCorrectAddress;
        return this;
    }

    public AddressCreator setStreetSecondary(String streetSecondary) {
        this.streetSecondary = streetSecondary;
        return this;
    }

    @Override
    public Address create(TwilioRestClient client) {
        String path = "/2010-04-01/Accounts/{AccountSid}/Addresses.json";
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        path = path.replace("{AccountSid}", this.pathAccountSid.toString());
        path = path.replace("{CustomerName}", this.customerName.toString());
        path = path.replace("{Street}", this.street.toString());
        path = path.replace("{City}", this.city.toString());
        path = path.replace("{Region}", this.region.toString());
        path = path.replace("{PostalCode}", this.postalCode.toString());
        path = path.replace("{IsoCountry}", this.isoCountry.toString());
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Address creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Address.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.customerName != null) {
            request.addPostParam("CustomerName", this.customerName);
        }
        if (this.street != null) {
            request.addPostParam("Street", this.street);
        }
        if (this.city != null) {
            request.addPostParam("City", this.city);
        }
        if (this.region != null) {
            request.addPostParam("Region", this.region);
        }
        if (this.postalCode != null) {
            request.addPostParam("PostalCode", this.postalCode);
        }
        if (this.isoCountry != null) {
            request.addPostParam("IsoCountry", this.isoCountry);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.emergencyEnabled != null) {
            request.addPostParam("EmergencyEnabled", this.emergencyEnabled.toString());
        }
        if (this.autoCorrectAddress != null) {
            request.addPostParam("AutoCorrectAddress", this.autoCorrectAddress.toString());
        }
        if (this.streetSecondary != null) {
            request.addPostParam("StreetSecondary", this.streetSecondary);
        }
    }
}

