/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.accounts.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.accounts.v1.AuthTokenPromotion;

public class AuthTokenPromotionUpdater
extends Updater<AuthTokenPromotion> {
    @Override
    public AuthTokenPromotion update(TwilioRestClient client) {
        String path = "/v1/AuthTokens/Promote";
        Request request = new Request(HttpMethod.POST, Domains.ACCOUNTS.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AuthTokenPromotion update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return AuthTokenPromotion.fromJson(response.getStream(), client.getObjectMapper());
    }
}

