/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.utils;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.NodeConfiguration;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.service.component.RuleNodeClassInfo;

/*
 * Exception performing whole class analysis ignored.
 */
public class TbNodeUpgradeUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbNodeUpgradeUtils.class);

    public static void upgradeConfigurationAndVersion(RuleNode node, RuleNodeClassInfo nodeInfo) {
        JsonNode oldConfiguration = node.getConfiguration();
        int configurationVersion = node.getConfigurationVersion();
        int currentVersion = nodeInfo.getCurrentVersion();
        Class configClass = nodeInfo.getAnnotation().configClazz();
        if (oldConfiguration == null || !oldConfiguration.isObject()) {
            log.warn("Failed to upgrade rule node with id: {} type: {} fromVersion: {} toVersion: {}. Current configuration is null or not a json object. Going to set default configuration ... ", new Object[]{node.getId(), node.getType(), configurationVersion, currentVersion});
            node.setConfiguration(TbNodeUpgradeUtils.getDefaultConfig((Class)configClass));
        } else {
            TbNode tbVersionedNode = TbNodeUpgradeUtils.getTbVersionedNode((RuleNodeClassInfo)nodeInfo);
            try {
                JsonNode queueName = oldConfiguration.get("queueName");
                TbPair upgradeResult = tbVersionedNode.upgrade(configurationVersion, oldConfiguration);
                if (((Boolean)upgradeResult.getFirst()).booleanValue()) {
                    node.setConfiguration((JsonNode)upgradeResult.getSecond());
                    if (nodeInfo.getAnnotation().hasQueueName() && queueName != null && queueName.isTextual()) {
                        node.setQueueName(queueName.asText());
                    }
                }
            }
            catch (Exception e) {
                try {
                    JacksonUtil.treeToValue((JsonNode)oldConfiguration, (Class)configClass);
                }
                catch (Exception ex) {
                    log.warn("Failed to upgrade rule node with id: {} type: {} fromVersion: {} toVersion: {}. Going to set default configuration ... ", new Object[]{node.getId(), node.getType(), configurationVersion, currentVersion, e});
                    node.setConfiguration(TbNodeUpgradeUtils.getDefaultConfig((Class)configClass));
                }
            }
        }
        node.setConfigurationVersion(currentVersion);
    }

    private static TbNode getTbVersionedNode(RuleNodeClassInfo nodeInfo) {
        return (TbNode)nodeInfo.getClazz().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static JsonNode getDefaultConfig(Class<? extends NodeConfiguration> configClass) {
        return JacksonUtil.valueToTree((Object)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).defaultConfiguration());
    }
}

