/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.utils;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.Charset;

/*
 * Exception performing whole class analysis ignored.
 */
public class MiscUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static String missingProperty(String propertyName) {
        return "The " + propertyName + " property need to be set!";
    }

    public static HashFunction forName(String name) {
        switch (name) {
            case "murmur3_32": {
                return Hashing.murmur3_32();
            }
            case "murmur3_128": {
                return Hashing.murmur3_128();
            }
            case "crc32": {
                return Hashing.crc32();
            }
            case "md5": {
                return Hashing.md5();
            }
        }
        throw new IllegalArgumentException("Can't find hash function with name " + name);
    }

    public static String constructBaseUrl(HttpServletRequest request) {
        return String.format("%s://%s:%d", MiscUtils.getScheme((HttpServletRequest)request), MiscUtils.getDomainName((HttpServletRequest)request), MiscUtils.getPort((HttpServletRequest)request));
    }

    public static String getScheme(HttpServletRequest request) {
        String scheme = request.getScheme();
        String forwardedProto = request.getHeader("x-forwarded-proto");
        if (forwardedProto != null) {
            scheme = forwardedProto;
        }
        return scheme;
    }

    public static String getDomainName(HttpServletRequest request) {
        return request.getServerName();
    }

    public static String getDomainNameAndPort(HttpServletRequest request) {
        int port;
        Object domainName = MiscUtils.getDomainName((HttpServletRequest)request);
        String scheme = MiscUtils.getScheme((HttpServletRequest)request);
        if (MiscUtils.needsPort((String)scheme, (int)(port = MiscUtils.getPort((HttpServletRequest)request)))) {
            domainName = (String)domainName + ":" + port;
        }
        return domainName;
    }

    private static boolean needsPort(String scheme, int port) {
        boolean isHttpDefault = "http".equals(scheme.toLowerCase()) && port == 80;
        boolean isHttpsDefault = "https".equals(scheme.toLowerCase()) && port == 443;
        return !isHttpDefault && !isHttpsDefault;
    }

    public static int getPort(HttpServletRequest request) {
        String forwardedProto = request.getHeader("x-forwarded-proto");
        int serverPort = request.getServerPort();
        if (request.getHeader("x-forwarded-port") != null) {
            try {
                serverPort = request.getIntHeader("x-forwarded-port");
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (forwardedProto != null) {
            switch (forwardedProto) {
                case "http": {
                    serverPort = 80;
                    break;
                }
                case "https": {
                    serverPort = 443;
                }
            }
        }
        return serverPort;
    }
}

