/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.eclipse.leshan.core.model.InvalidDDFFileException;
import org.eclipse.leshan.core.model.ObjectModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.lwm2m.LwM2mInstance;
import org.thingsboard.server.common.data.lwm2m.LwM2mObject;
import org.thingsboard.server.common.data.lwm2m.LwM2mResourceObserve;
import org.thingsboard.server.common.data.util.TbDDFFileParser;
import org.thingsboard.server.exception.DataValidationException;

/*
 * Exception performing whole class analysis ignored.
 */
public class LwM2mObjectModelUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LwM2mObjectModelUtils.class);
    private static final TbDDFFileParser ddfFileParser = new TbDDFFileParser();

    public static void toLwm2mResource(TbResource resource) throws ThingsboardException {
        try {
            String name;
            String resourceKey;
            List objectModels = ddfFileParser.parse((InputStream)new ByteArrayInputStream(resource.getData()), resource.getSearchText());
            if (!objectModels.isEmpty()) {
                ObjectModel objectModel = (ObjectModel)objectModels.get(0);
                resourceKey = objectModel.id + "_" + objectModel.version;
                name = objectModel.name;
                resource.setResourceKey(resourceKey);
                if (resource.getId() == null) {
                    resource.setTitle(name + " id=" + objectModel.id + " v" + objectModel.version);
                }
            } else {
                throw new DataValidationException(String.format("Could not parse the XML of objectModel with name %s", resource.getSearchText()));
            }
            resource.setSearchText(resourceKey + ":" + name);
        }
        catch (InvalidDDFFileException e) {
            log.error("Failed to parse file {}", (Object)resource.getFileName(), (Object)e);
            throw new DataValidationException("Failed to parse file " + resource.getFileName());
        }
        catch (IOException e) {
            throw new ThingsboardException((Throwable)e, ThingsboardErrorCode.GENERAL);
        }
        if (resource.getResourceType().equals((Object)ResourceType.LWM2M_MODEL) && LwM2mObjectModelUtils.toLwM2mObject((TbResource)resource, (boolean)true) == null) {
            throw new DataValidationException(String.format("Could not parse the XML of objectModel with name %s", resource.getSearchText()));
        }
    }

    public static LwM2mObject toLwM2mObject(TbResource resource, boolean isSave) {
        try {
            List objectModels = ddfFileParser.parse((InputStream)new ByteArrayInputStream(resource.getData()), resource.getSearchText());
            if (objectModels.isEmpty()) {
                return null;
            }
            ObjectModel obj = (ObjectModel)objectModels.get(0);
            LwM2mObject lwM2mObject = new LwM2mObject();
            lwM2mObject.setId(obj.id.intValue());
            lwM2mObject.setKeyId(resource.getResourceKey());
            lwM2mObject.setName(obj.name);
            lwM2mObject.setMultiple(obj.multiple.booleanValue());
            lwM2mObject.setMandatory(obj.mandatory.booleanValue());
            LwM2mInstance instance = new LwM2mInstance();
            instance.setId(0);
            ArrayList resources = new ArrayList();
            obj.resources.forEach((k, v) -> {
                if (isSave) {
                    LwM2mResourceObserve lwM2MResourceObserve = new LwM2mResourceObserve(k.intValue(), v.name, false, false, false);
                    resources.add(lwM2MResourceObserve);
                } else if (v.operations.isReadable()) {
                    LwM2mResourceObserve lwM2MResourceObserve = new LwM2mResourceObserve(k.intValue(), v.name, false, false, false);
                    resources.add(lwM2MResourceObserve);
                }
            });
            if (isSave || !resources.isEmpty()) {
                instance.setResources((LwM2mResourceObserve[])resources.toArray(LwM2mResourceObserve[]::new));
                lwM2mObject.setInstances(new LwM2mInstance[]{instance});
                return lwM2mObject;
            }
            return null;
        }
        catch (IOException | InvalidDDFFileException e) {
            log.error("Could not parse the XML of objectModel with name [{}]", (Object)resource.getSearchText(), (Object)e);
            return null;
        }
    }
}

