/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.geofencing.GeofencingPresenceStatus;
import org.thingsboard.server.common.data.id.CalculatedFieldId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BasicKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.util.KvProtoUtil;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.ScriptCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SimpleCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.TsRollingArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.RelatedEntitiesAggregationCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.aggregation.RelatedEntitiesArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.AggIntervalEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.AggIntervalEntryStatus;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.EntityAggregationArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.EntityAggregationCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.alarm.AlarmCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.alarm.AlarmRuleState;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingZoneState;
import org.thingsboard.server.service.cf.ctx.state.propagation.PropagationArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.propagation.PropagationCalculatedFieldState;
import org.thingsboard.server.utils.CalculatedFieldUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculatedFieldUtils {
    public static TransportProtos.CalculatedFieldIdProto toProto(CalculatedFieldId cfId) {
        return TransportProtos.CalculatedFieldIdProto.newBuilder().setCalculatedFieldIdMSB(cfId.getId().getMostSignificantBits()).setCalculatedFieldIdLSB(cfId.getId().getLeastSignificantBits()).build();
    }

    public static TransportProtos.CalculatedFieldEntityCtxIdProto toProto(CalculatedFieldEntityCtxId ctxId) {
        return TransportProtos.CalculatedFieldEntityCtxIdProto.newBuilder().setTenantIdMSB(ctxId.tenantId().getId().getMostSignificantBits()).setTenantIdLSB(ctxId.tenantId().getId().getLeastSignificantBits()).setCalculatedFieldIdMSB(ctxId.cfId().getId().getMostSignificantBits()).setCalculatedFieldIdLSB(ctxId.cfId().getId().getLeastSignificantBits()).setEntityType(ctxId.entityId().getEntityType().name()).setEntityIdMSB(ctxId.entityId().getId().getMostSignificantBits()).setEntityIdLSB(ctxId.entityId().getId().getLeastSignificantBits()).build();
    }

    public static CalculatedFieldEntityCtxId fromProto(TransportProtos.CalculatedFieldEntityCtxIdProto ctxIdProto) {
        TenantId tenantId = TenantId.fromUUID((UUID)new UUID(ctxIdProto.getTenantIdMSB(), ctxIdProto.getTenantIdLSB()));
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((String)ctxIdProto.getEntityType(), (UUID)new UUID(ctxIdProto.getEntityIdMSB(), ctxIdProto.getEntityIdLSB()));
        CalculatedFieldId calculatedFieldId = new CalculatedFieldId(new UUID(ctxIdProto.getCalculatedFieldIdMSB(), ctxIdProto.getCalculatedFieldIdLSB()));
        return new CalculatedFieldEntityCtxId(tenantId, calculatedFieldId, entityId);
    }

    public static TransportProtos.CalculatedFieldStateProto toProto(CalculatedFieldEntityCtxId stateId, CalculatedFieldState state) {
        TransportProtos.CalculatedFieldStateProto.Builder builder = TransportProtos.CalculatedFieldStateProto.newBuilder().setId(CalculatedFieldUtils.toProto((CalculatedFieldEntityCtxId)stateId)).setType(state.getType().name());
        state.getArguments().forEach((argName, argEntry) -> {
            switch (1.$SwitchMap$org$thingsboard$server$service$cf$ctx$state$ArgumentEntryType[argEntry.getType().ordinal()]) {
                case 1: {
                    builder.addSingleValueArguments(CalculatedFieldUtils.toSingleValueArgumentProto((String)argName, (SingleValueArgumentEntry)((SingleValueArgumentEntry)argEntry)));
                    break;
                }
                case 2: {
                    builder.addRollingValueArguments(CalculatedFieldUtils.toRollingArgumentProto((String)argName, (TsRollingArgumentEntry)((TsRollingArgumentEntry)argEntry)));
                    break;
                }
                case 3: {
                    builder.addGeofencingArguments(CalculatedFieldUtils.toGeofencingArgumentProto((String)argName, (GeofencingArgumentEntry)((GeofencingArgumentEntry)argEntry)));
                    break;
                }
                case 4: {
                    builder.addAllPropagationEntityIds((Iterable)CalculatedFieldUtils.toPropagationEntityIdsProto((PropagationArgumentEntry)((PropagationArgumentEntry)argEntry)));
                    break;
                }
                case 5: {
                    RelatedEntitiesArgumentEntry relatedEntitiesArgumentEntry = (RelatedEntitiesArgumentEntry)argEntry;
                    Map entityInputs = relatedEntitiesArgumentEntry.getEntityInputs();
                    if (entityInputs.isEmpty()) {
                        builder.addSingleValueArguments(TransportProtos.SingleValueArgumentProto.newBuilder().setArgName(argName).build());
                        break;
                    }
                    entityInputs.forEach((entityId, entry) -> builder.addSingleValueArguments(CalculatedFieldUtils.toSingleValueArgumentProto((String)argName, (SingleValueArgumentEntry)((SingleValueArgumentEntry)entry))));
                    break;
                }
                case 6: {
                    EntityAggregationArgumentEntry entityAggregationArgumentEntry = (EntityAggregationArgumentEntry)argEntry;
                    entityAggregationArgumentEntry.getAggIntervals().forEach((interval, argumentStatus) -> builder.addAggregationArguments(CalculatedFieldUtils.toArgumentIntervalProto((String)argName, (AggIntervalEntry)interval, (AggIntervalEntryStatus)argumentStatus)));
                }
            }
        });
        if (state instanceof AlarmCalculatedFieldState) {
            AlarmCalculatedFieldState alarmState = (AlarmCalculatedFieldState)state;
            TransportProtos.AlarmStateProto.Builder alarmStateProto = TransportProtos.AlarmStateProto.newBuilder();
            alarmState.getCreateRuleStates().forEach((severity, ruleState) -> alarmStateProto.addCreateRuleStates(CalculatedFieldUtils.toAlarmRuleStateProto((AlarmRuleState)ruleState)));
            if (alarmState.getClearRuleState() != null) {
                alarmStateProto.setClearRuleState(CalculatedFieldUtils.toAlarmRuleStateProto((AlarmRuleState)alarmState.getClearRuleState()));
            }
            builder.setAlarmState(alarmStateProto);
        }
        if (state instanceof RelatedEntitiesAggregationCalculatedFieldState) {
            RelatedEntitiesAggregationCalculatedFieldState aggState = (RelatedEntitiesAggregationCalculatedFieldState)state;
            builder.setLastArgsUpdateTs(aggState.getLastArgsRefreshTs());
            builder.setLastMetricsEvalTs(aggState.getLastMetricsEvalTs());
        }
        return builder.build();
    }

    private static List<TransportProtos.EntityIdProto> toPropagationEntityIdsProto(PropagationArgumentEntry argEntry) {
        return argEntry.getEntityIds().stream().map(ProtoUtils::toProto).collect(Collectors.toList());
    }

    private static TransportProtos.AlarmRuleStateProto toAlarmRuleStateProto(AlarmRuleState ruleState) {
        return TransportProtos.AlarmRuleStateProto.newBuilder().setSeverity(Optional.ofNullable(ruleState.getSeverity()).map(Enum::name).orElse("")).setEventCount(ruleState.getEventCount()).setFirstEventTs(ruleState.getFirstEventTs()).setLastCheckTs(ruleState.getLastCheckTs()).build();
    }

    private static AlarmRuleState fromAlarmRuleStateProto(TransportProtos.AlarmRuleStateProto proto, AlarmCalculatedFieldState state) {
        AlarmSeverity severity = StringUtils.isNotEmpty((String)proto.getSeverity()) ? AlarmSeverity.valueOf((String)proto.getSeverity()) : null;
        AlarmRuleState ruleState = new AlarmRuleState(severity, null, state);
        ruleState.setEventCount(proto.getEventCount());
        ruleState.setFirstEventTs(proto.getFirstEventTs());
        ruleState.setLastCheckTs(proto.getLastCheckTs());
        return ruleState;
    }

    public static TransportProtos.SingleValueArgumentProto toSingleValueArgumentProto(String argName, SingleValueArgumentEntry entry) {
        TransportProtos.SingleValueArgumentProto.Builder builder = TransportProtos.SingleValueArgumentProto.newBuilder().setArgName(argName);
        if (entry.getKvEntryValue() != null) {
            builder.setValue(KvProtoUtil.toTsValueProto((long)entry.getTs(), (KvEntry)entry.getKvEntryValue()));
        }
        Optional.ofNullable(entry.getVersion()).ifPresent(arg_0 -> ((TransportProtos.SingleValueArgumentProto.Builder)builder).setVersion(arg_0));
        if (entry.getEntityId() != null) {
            builder.setEntityId(ProtoUtils.toProto((EntityId)entry.getEntityId()));
        }
        return builder.build();
    }

    public static TransportProtos.ArgumentIntervalProto toArgumentIntervalProto(String argName, AggIntervalEntry intervalEntry, AggIntervalEntryStatus argumentStatus) {
        return TransportProtos.ArgumentIntervalProto.newBuilder().setArgName(argName).setStartTs(intervalEntry.getStartTs().longValue()).setEndTs(intervalEntry.getEndTs().longValue()).setLastArgsRefreshTs(argumentStatus.getLastArgsRefreshTs()).setLastMetricsEvalTs(argumentStatus.getLastMetricsEvalTs()).build();
    }

    public static TransportProtos.TsRollingArgumentProto toRollingArgumentProto(String argName, TsRollingArgumentEntry entry) {
        TransportProtos.TsRollingArgumentProto.Builder builder = TransportProtos.TsRollingArgumentProto.newBuilder().setKey(argName).setLimit(entry.getLimit().intValue()).setTimeWindow(entry.getTimeWindow().longValue());
        entry.getTsRecords().forEach((ts, value) -> builder.addTsValue(TransportProtos.TsDoubleValProto.newBuilder().setTs(ts.longValue()).setValue(value.doubleValue()).build()));
        return builder.build();
    }

    private static TransportProtos.GeofencingArgumentProto toGeofencingArgumentProto(String argName, GeofencingArgumentEntry geofencingArgumentEntry) {
        Map zoneStates = geofencingArgumentEntry.getZoneStates();
        TransportProtos.GeofencingArgumentProto.Builder builder = TransportProtos.GeofencingArgumentProto.newBuilder().setArgName(argName);
        zoneStates.forEach((entityId, zoneState) -> builder.addZones(CalculatedFieldUtils.toGeofencingZoneProto((EntityId)entityId, (GeofencingZoneState)zoneState)));
        return builder.build();
    }

    private static TransportProtos.GeofencingZoneProto toGeofencingZoneProto(EntityId entityId, GeofencingZoneState zoneState) {
        TransportProtos.GeofencingZoneProto.Builder builder = TransportProtos.GeofencingZoneProto.newBuilder().setZoneId(ProtoUtils.toProto((EntityId)entityId)).setTs(zoneState.getTs()).setVersion(zoneState.getVersion().longValue()).setPerimeterDefinition(JacksonUtil.toString((Object)zoneState.getPerimeterDefinition()));
        if (zoneState.getLastPresence() != null) {
            builder.setInside(zoneState.getLastPresence().equals((Object)GeofencingPresenceStatus.INSIDE));
        }
        return builder.build();
    }

    public static CalculatedFieldState fromProto(CalculatedFieldEntityCtxId id, TransportProtos.CalculatedFieldStateProto proto) {
        SimpleCalculatedFieldState state;
        if (StringUtils.isEmpty((String)proto.getType())) {
            return null;
        }
        CalculatedFieldType type = CalculatedFieldType.valueOf((String)proto.getType());
        switch (1.$SwitchMap$org$thingsboard$server$common$data$cf$CalculatedFieldType[type.ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: {
                SimpleCalculatedFieldState simpleCalculatedFieldState = new SimpleCalculatedFieldState(id.entityId());
                break;
            }
            case 2: {
                SimpleCalculatedFieldState simpleCalculatedFieldState = new ScriptCalculatedFieldState(id.entityId());
                break;
            }
            case 3: {
                SimpleCalculatedFieldState simpleCalculatedFieldState = new GeofencingCalculatedFieldState(id.entityId());
                break;
            }
            case 4: {
                SimpleCalculatedFieldState simpleCalculatedFieldState = new AlarmCalculatedFieldState(id.entityId());
                break;
            }
            case 5: {
                SimpleCalculatedFieldState simpleCalculatedFieldState = new PropagationCalculatedFieldState(id.entityId());
                break;
            }
            case 6: {
                SimpleCalculatedFieldState simpleCalculatedFieldState = new RelatedEntitiesAggregationCalculatedFieldState(id.entityId());
                break;
            }
            case 7: {
                SimpleCalculatedFieldState simpleCalculatedFieldState = state = new EntityAggregationCalculatedFieldState(id.entityId());
            }
        }
        if (state instanceof RelatedEntitiesAggregationCalculatedFieldState) {
            RelatedEntitiesAggregationCalculatedFieldState relatedEntitiesAggState = (RelatedEntitiesAggregationCalculatedFieldState)state;
            HashMap<String, Map> arguments = new HashMap<String, Map>();
            proto.getSingleValueArgumentsList().forEach(argProto -> {
                SingleValueArgumentEntry entry = CalculatedFieldUtils.fromSingleValueArgumentProto((TransportProtos.SingleValueArgumentProto)argProto);
                Map entityInputs = arguments.computeIfAbsent(argProto.getArgName(), name -> new HashMap());
                if (entry.getEntityId() != null) {
                    entityInputs.put(entry.getEntityId(), entry);
                }
            });
            arguments.forEach((argName, entityInputs) -> relatedEntitiesAggState.getArguments().put(argName, new RelatedEntitiesArgumentEntry(entityInputs, false)));
            relatedEntitiesAggState.setLastArgsRefreshTs(proto.getLastArgsUpdateTs());
            relatedEntitiesAggState.setLastMetricsEvalTs(proto.getLastMetricsEvalTs());
            return relatedEntitiesAggState;
        }
        if (state instanceof EntityAggregationCalculatedFieldState) {
            EntityAggregationCalculatedFieldState entityAggregationState = (EntityAggregationCalculatedFieldState)state;
            HashMap arguments = new HashMap();
            proto.getAggregationArgumentsList().forEach(argProto -> {
                AggIntervalEntry intervalEntry = new AggIntervalEntry(Long.valueOf(argProto.getStartTs()), Long.valueOf(argProto.getEndTs()));
                AggIntervalEntryStatus intervalStatus = new AggIntervalEntryStatus(argProto.getLastArgsRefreshTs(), argProto.getLastMetricsEvalTs());
                EntityAggregationArgumentEntry argEntry = arguments.computeIfAbsent(argProto.getArgName(), name -> new EntityAggregationArgumentEntry(new HashMap()));
                argEntry.getAggIntervals().put(intervalEntry, intervalStatus);
            });
            entityAggregationState.getArguments().putAll(arguments);
            return entityAggregationState;
        }
        proto.getSingleValueArgumentsList().forEach(arg_0 -> CalculatedFieldUtils.lambda$fromProto$11((CalculatedFieldState)state, arg_0));
        switch (1.$SwitchMap$org$thingsboard$server$common$data$cf$CalculatedFieldType[type.ordinal()]) {
            case 2: {
                proto.getRollingValueArgumentsList().forEach(arg_0 -> CalculatedFieldUtils.lambda$fromProto$12((CalculatedFieldState)state, arg_0));
                break;
            }
            case 3: {
                proto.getGeofencingArgumentsList().forEach(arg_0 -> CalculatedFieldUtils.lambda$fromProto$13((CalculatedFieldState)state, arg_0));
                break;
            }
            case 5: {
                List<EntityId> propagationEntityIds = proto.getPropagationEntityIdsList().stream().map(ProtoUtils::fromProto).toList();
                state.getArguments().put("propagationCtx", new PropagationArgumentEntry(propagationEntityIds));
                break;
            }
            case 4: {
                AlarmCalculatedFieldState alarmState = (AlarmCalculatedFieldState)state;
                TransportProtos.AlarmStateProto alarmStateProto = proto.getAlarmState();
                for (TransportProtos.AlarmRuleStateProto ruleStateProto : alarmStateProto.getCreateRuleStatesList()) {
                    AlarmRuleState ruleState = CalculatedFieldUtils.fromAlarmRuleStateProto((TransportProtos.AlarmRuleStateProto)ruleStateProto, (AlarmCalculatedFieldState)alarmState);
                    alarmState.getCreateRuleStates().put(ruleState.getSeverity(), ruleState);
                }
                if (!alarmStateProto.hasClearRuleState()) break;
                alarmState.setClearRuleState(CalculatedFieldUtils.fromAlarmRuleStateProto((TransportProtos.AlarmRuleStateProto)alarmStateProto.getClearRuleState(), (AlarmCalculatedFieldState)alarmState));
            }
        }
        return state;
    }

    public static SingleValueArgumentEntry fromSingleValueArgumentProto(TransportProtos.SingleValueArgumentProto proto) {
        if (!proto.hasValue()) {
            return new SingleValueArgumentEntry();
        }
        TransportProtos.TsValueProto tsValueProto = proto.getValue();
        BasicKvEntry kvEntry = (BasicKvEntry)KvProtoUtil.fromTsValueProto((String)proto.getArgName(), (TransportProtos.TsValueProto)tsValueProto);
        long ts = tsValueProto.getTs();
        long version = proto.getVersion();
        if (proto.hasEntityId()) {
            EntityId entityId = ProtoUtils.fromProto((TransportProtos.EntityIdProto)proto.getEntityId());
            return new SingleValueArgumentEntry(entityId, ts, kvEntry, Long.valueOf(version));
        }
        return new SingleValueArgumentEntry(ts, kvEntry, Long.valueOf(version));
    }

    public static TsRollingArgumentEntry fromRollingArgumentProto(TransportProtos.TsRollingArgumentProto proto) {
        TreeMap tsRecords = new TreeMap();
        proto.getTsValueList().forEach(tsValueProto -> tsRecords.put(tsValueProto.getTs(), tsValueProto.getValue()));
        return new TsRollingArgumentEntry(tsRecords, proto.getLimit(), proto.getTimeWindow());
    }

    private static ArgumentEntry fromGeofencingArgumentProto(TransportProtos.GeofencingArgumentProto proto) {
        Map zoneStates = proto.getZonesList().stream().map(GeofencingZoneState::new).collect(Collectors.toMap(GeofencingZoneState::getZoneId, Function.identity()));
        GeofencingArgumentEntry geofencingArgumentEntry = new GeofencingArgumentEntry();
        geofencingArgumentEntry.setZoneStates(zoneStates);
        return geofencingArgumentEntry;
    }

    private static /* synthetic */ void lambda$fromProto$13(CalculatedFieldState state, TransportProtos.GeofencingArgumentProto argProto) {
        state.getArguments().put(argProto.getArgName(), CalculatedFieldUtils.fromGeofencingArgumentProto((TransportProtos.GeofencingArgumentProto)argProto));
    }

    private static /* synthetic */ void lambda$fromProto$12(CalculatedFieldState state, TransportProtos.TsRollingArgumentProto argProto) {
        state.getArguments().put(argProto.getKey(), CalculatedFieldUtils.fromRollingArgumentProto((TransportProtos.TsRollingArgumentProto)argProto));
    }

    private static /* synthetic */ void lambda$fromProto$11(CalculatedFieldState state, TransportProtos.SingleValueArgumentProto argProto) {
        state.getArguments().put(argProto.getArgName(), CalculatedFieldUtils.fromSingleValueArgumentProto((TransportProtos.SingleValueArgumentProto)argProto));
    }
}

