/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.utils;

import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.math.NumberUtils;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.aggregation.AggMetric;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.ScriptCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SimpleCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.RelatedEntitiesAggregationCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.AggIntervalEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.AggIntervalEntryStatus;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.EntityAggregationArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.aggregation.single.EntityAggregationCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.alarm.AlarmCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.geofencing.GeofencingCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.propagation.PropagationCalculatedFieldState;
import org.thingsboard.server.utils.CalculatedFieldArgumentUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculatedFieldArgumentUtils {
    public static ArgumentEntry transformSingleValueArgument(@NonNull KvEntry kvEntry) {
        if (kvEntry == null) {
            throw new NullPointerException("kvEntry is marked non-null but is null");
        }
        return kvEntry.getValue() != null ? ArgumentEntry.createSingleValueArgument((KvEntry)kvEntry) : new SingleValueArgumentEntry();
    }

    public static ArgumentEntry transformTsRollingArgument(List<TsKvEntry> tsRolling, int limit, long argTimeWindow) {
        return ArgumentEntry.createTsRollingArgument(tsRolling, (int)limit, (long)argTimeWindow);
    }

    public static ArgumentEntry transformAggMetricArgument(List<TsKvEntry> timeSeries, String argKey, AggMetric aggMetric) {
        if (timeSeries == null || timeSeries.isEmpty()) {
            return CalculatedFieldArgumentUtils.createDefaultMetricArgumentEntry((String)argKey, (AggMetric)aggMetric);
        }
        return ArgumentEntry.createSingleValueArgument((KvEntry)((KvEntry)timeSeries.get(0)));
    }

    public static ArgumentEntry createDefaultMetricArgumentEntry(String argKey, AggMetric metric) {
        Double defaultValue = metric.getDefaultValue();
        if (defaultValue != null) {
            return ArgumentEntry.createSingleValueArgument((KvEntry)new DoubleDataEntry(argKey, defaultValue));
        }
        return new SingleValueArgumentEntry();
    }

    public static ArgumentEntry transformAggregationArgument(List<TsKvEntry> timeSeries, long startIntervalTs, long endIntervalTs) {
        HashMap<AggIntervalEntry, AggIntervalEntryStatus> aggIntervals = new HashMap<AggIntervalEntry, AggIntervalEntryStatus>();
        AggIntervalEntry aggIntervalEntry = new AggIntervalEntry(Long.valueOf(startIntervalTs), Long.valueOf(endIntervalTs));
        if (timeSeries == null || timeSeries.isEmpty()) {
            aggIntervals.put(aggIntervalEntry, new AggIntervalEntryStatus());
        } else {
            aggIntervals.put(aggIntervalEntry, new AggIntervalEntryStatus(System.currentTimeMillis()));
        }
        return new EntityAggregationArgumentEntry(aggIntervals);
    }

    private static KvEntry createDefaultKvEntry(Argument argument) {
        String key = argument.getRefEntityKey().getKey();
        String defaultValue = argument.getDefaultValue();
        if (StringUtils.isBlank((String)defaultValue)) {
            return new StringDataEntry(key, null);
        }
        if (NumberUtils.isParsable((String)defaultValue)) {
            return new DoubleDataEntry(key, Double.valueOf(Double.parseDouble(defaultValue)));
        }
        if ("true".equalsIgnoreCase(defaultValue) || "false".equalsIgnoreCase(defaultValue)) {
            return new BooleanDataEntry(key, Boolean.valueOf(Boolean.parseBoolean(defaultValue)));
        }
        return new StringDataEntry(key, defaultValue);
    }

    public static TsKvEntry createDefaultTsKvEntry(Argument argument, long ts) {
        return new BasicTsKvEntry(ts, CalculatedFieldArgumentUtils.createDefaultKvEntry((Argument)argument), SingleValueArgumentEntry.DEFAULT_VERSION);
    }

    public static AttributeKvEntry createDefaultAttributeEntry(Argument argument, long ts) {
        return new BaseAttributeKvEntry(CalculatedFieldArgumentUtils.createDefaultKvEntry((Argument)argument), ts, SingleValueArgumentEntry.DEFAULT_VERSION);
    }

    public static CalculatedFieldState createStateByType(CalculatedFieldCtx ctx, EntityId entityId) {
        return switch (1.$SwitchMap$org$thingsboard$server$common$data$cf$CalculatedFieldType[ctx.getCfType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> new SimpleCalculatedFieldState(entityId);
            case 2 -> new ScriptCalculatedFieldState(entityId);
            case 3 -> new GeofencingCalculatedFieldState(entityId);
            case 4 -> new AlarmCalculatedFieldState(entityId);
            case 5 -> new PropagationCalculatedFieldState(entityId);
            case 6 -> new RelatedEntitiesAggregationCalculatedFieldState(entityId);
            case 7 -> new EntityAggregationCalculatedFieldState(entityId);
        };
    }
}

