/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ws.telemetry.cmd.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;
import org.thingsboard.server.common.data.query.EntityDataQuery;
import org.thingsboard.server.service.ws.WsCmdType;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.AggHistoryCmd;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.AggTimeSeriesCmd;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.DataCmd;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.EntityHistoryCmd;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.LatestValueCmd;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.TimeSeriesCmd;

public class EntityDataCmd
extends DataCmd {
    private final EntityDataQuery query;
    private final EntityHistoryCmd historyCmd;
    private final LatestValueCmd latestCmd;
    private final TimeSeriesCmd tsCmd;
    private final AggHistoryCmd aggHistoryCmd;
    private final AggTimeSeriesCmd aggTsCmd;

    public EntityDataCmd(int cmdId, EntityDataQuery query, EntityHistoryCmd historyCmd, LatestValueCmd latestCmd, TimeSeriesCmd tsCmd) {
        this(cmdId, query, historyCmd, latestCmd, tsCmd, null, null);
    }

    @JsonCreator
    public EntityDataCmd(@JsonProperty(value="cmdId") int cmdId, @JsonProperty(value="query") EntityDataQuery query, @JsonProperty(value="historyCmd") EntityHistoryCmd historyCmd, @JsonProperty(value="latestCmd") LatestValueCmd latestCmd, @JsonProperty(value="tsCmd") TimeSeriesCmd tsCmd, @JsonProperty(value="aggHistoryCmd") AggHistoryCmd aggHistoryCmd, @JsonProperty(value="aggTsCmd") AggTimeSeriesCmd aggTsCmd) {
        super(cmdId);
        this.query = query;
        this.historyCmd = historyCmd;
        this.latestCmd = latestCmd;
        this.tsCmd = tsCmd;
        this.aggHistoryCmd = aggHistoryCmd;
        this.aggTsCmd = aggTsCmd;
    }

    @JsonIgnore
    public boolean hasAnyCmd() {
        return this.historyCmd != null || this.latestCmd != null || this.tsCmd != null || this.aggHistoryCmd != null || this.aggTsCmd != null;
    }

    public WsCmdType getType() {
        return WsCmdType.ENTITY_DATA;
    }

    @Generated
    public EntityDataQuery getQuery() {
        return this.query;
    }

    @Generated
    public EntityHistoryCmd getHistoryCmd() {
        return this.historyCmd;
    }

    @Generated
    public LatestValueCmd getLatestCmd() {
        return this.latestCmd;
    }

    @Generated
    public TimeSeriesCmd getTsCmd() {
        return this.tsCmd;
    }

    @Generated
    public AggHistoryCmd getAggHistoryCmd() {
        return this.aggHistoryCmd;
    }

    @Generated
    public AggTimeSeriesCmd getAggTsCmd() {
        return this.aggTsCmd;
    }
}

