/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ws.notification.sub;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.Notification;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.service.subscription.TbSubscription;
import org.thingsboard.server.service.subscription.TbSubscriptionType;
import org.thingsboard.server.service.ws.notification.cmd.UnreadNotificationsUpdate;
import org.thingsboard.server.service.ws.notification.sub.AbstractNotificationSubscription;
import org.thingsboard.server.service.ws.notification.sub.NotificationsSubscription;
import org.thingsboard.server.service.ws.notification.sub.NotificationsSubscriptionUpdate;

public class NotificationsSubscription
extends AbstractNotificationSubscription<NotificationsSubscriptionUpdate> {
    private final Map<UUID, Notification> latestUnreadNotifications = new HashMap();
    private final int limit;
    private final Set<NotificationType> notificationTypes;

    public NotificationsSubscription(String serviceId, String sessionId, int subscriptionId, TenantId tenantId, EntityId entityId, BiConsumer<TbSubscription<NotificationsSubscriptionUpdate>, NotificationsSubscriptionUpdate> updateProcessor, int limit, Set<NotificationType> notificationTypes) {
        super(serviceId, sessionId, subscriptionId, tenantId, entityId, TbSubscriptionType.NOTIFICATIONS, updateProcessor);
        this.limit = limit;
        this.notificationTypes = notificationTypes;
    }

    public boolean checkNotificationType(NotificationType type) {
        return CollectionUtils.isEmpty((Collection)this.notificationTypes) || this.notificationTypes.contains(type);
    }

    public UnreadNotificationsUpdate createFullUpdate() {
        return UnreadNotificationsUpdate.builder().cmdId(this.getSubscriptionId()).notifications(this.getSortedNotifications()).totalUnreadCount(this.totalUnreadCounter.get()).sequenceNumber(this.sequence.incrementAndGet()).build();
    }

    public List<Notification> getSortedNotifications() {
        return this.latestUnreadNotifications.values().stream().sorted(Comparator.comparing(BaseData::getCreatedTime, Comparator.reverseOrder())).collect(Collectors.toList());
    }

    public UnreadNotificationsUpdate createPartialUpdate(Notification notification) {
        return UnreadNotificationsUpdate.builder().cmdId(this.getSubscriptionId()).update(notification).totalUnreadCount(this.totalUnreadCounter.get()).sequenceNumber(this.sequence.incrementAndGet()).build();
    }

    public UnreadNotificationsUpdate createCountUpdate() {
        return UnreadNotificationsUpdate.builder().cmdId(this.getSubscriptionId()).totalUnreadCount(this.totalUnreadCounter.get()).sequenceNumber(this.sequence.incrementAndGet()).build();
    }

    @Generated
    public static NotificationsSubscriptionBuilder builder() {
        return new NotificationsSubscriptionBuilder();
    }

    @Generated
    public Map<UUID, Notification> getLatestUnreadNotifications() {
        return this.latestUnreadNotifications;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public Set<NotificationType> getNotificationTypes() {
        return this.notificationTypes;
    }
}

